/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.methods.request.oauth;

import com.github.seratch.jslack.api.methods.SlackApiRequest;

public class OAuthAccessRequest
implements SlackApiRequest {
    private String clientId;
    private String clientSecret;
    private String code;
    private String redirectUri;
    private boolean singleChannel;

    OAuthAccessRequest(String clientId, String clientSecret, String code, String redirectUri, boolean singleChannel) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
        this.singleChannel = singleChannel;
    }

    public static OAuthAccessRequestBuilder builder() {
        return new OAuthAccessRequestBuilder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getCode() {
        return this.code;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public boolean isSingleChannel() {
        return this.singleChannel;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setSingleChannel(boolean singleChannel) {
        this.singleChannel = singleChannel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthAccessRequest)) {
            return false;
        }
        OAuthAccessRequest other = (OAuthAccessRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        return this.isSingleChannel() == other.isSingleChannel();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthAccessRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        result = result * 59 + (this.isSingleChannel() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OAuthAccessRequest(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", code=" + this.getCode() + ", redirectUri=" + this.getRedirectUri() + ", singleChannel=" + this.isSingleChannel() + ")";
    }

    public static class OAuthAccessRequestBuilder {
        private String clientId;
        private String clientSecret;
        private String code;
        private String redirectUri;
        private boolean singleChannel;

        OAuthAccessRequestBuilder() {
        }

        public OAuthAccessRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuthAccessRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuthAccessRequestBuilder code(String code) {
            this.code = code;
            return this;
        }

        public OAuthAccessRequestBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public OAuthAccessRequestBuilder singleChannel(boolean singleChannel) {
            this.singleChannel = singleChannel;
            return this;
        }

        public OAuthAccessRequest build() {
            return new OAuthAccessRequest(this.clientId, this.clientSecret, this.code, this.redirectUri, this.singleChannel);
        }

        public String toString() {
            return "OAuthAccessRequest.OAuthAccessRequestBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", code=" + this.code + ", redirectUri=" + this.redirectUri + ", singleChannel=" + this.singleChannel + ")";
        }
    }
}

