/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.app_backend.vendor.aws.lambda.util;

import com.github.seratch.jslack.app_backend.SlackSignature;
import com.github.seratch.jslack.app_backend.vendor.aws.lambda.request.ApiGatewayRequest;

public class SlackSignatureVerifier {
    private final SlackSignature.Generator signatureGenerator;

    public SlackSignatureVerifier() {
        this(new SlackSignature.Generator());
    }

    public SlackSignatureVerifier(SlackSignature.Generator signatureGenerator) {
        this.signatureGenerator = signatureGenerator;
    }

    public boolean isValid(ApiGatewayRequest request) {
        if (request != null && request.getHeaders() != null) {
            String requestTimestamp = request.getHeaders().get("X-Slack-Request-Timestamp");
            String requestBody = request.getBody();
            String expected = this.signatureGenerator.generate(requestTimestamp, requestBody);
            String actual = request.getHeaders().get("X-Slack-Signature");
            return actual != null && expected != null && actual.equals(expected);
        }
        return false;
    }
}

