/*
 * Decompiled with CFR 0.152.
 */
package kotliquery;

import java.io.Closeable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotliquery.Connection;
import kotliquery.LoanPattern;
import kotliquery.Parameter;
import kotliquery.ParameterKt;
import kotliquery.Query;
import kotliquery.Row;
import kotliquery.Session;
import kotliquery.TransactionalSession;
import kotliquery.action.ExecuteQueryAction;
import kotliquery.action.ListResultQueryAction;
import kotliquery.action.NullableResultQueryAction;
import kotliquery.action.UpdateAndReturnGeneratedKeyQueryAction;
import kotliquery.action.UpdateQueryAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u001f\u001a\u00020\b2\u001a\u0010 \u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010#0\"0!J0\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00072\u0006\u0010\u001f\u001a\u00020\b2\u001a\u0010 \u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010#0\"0!J*\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u001f\u001a\u00020\b2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0!0!J*\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u00072\u0006\u0010\u001f\u001a\u00020\b2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0!0!JJ\u0010(\u001a\u00020)2\u001a\u0010*\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010#0\"0!2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010+\u001a\u00020,2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0!0!H\u0002J\b\u0010-\u001a\u00020)H\u0016J\u001c\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020#0!J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u00052\u0006\u00103\u001a\u000204J\"\u00106\u001a\u00020)2\u0006\u00103\u001a\u0002042\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020)08J0\u0010:\u001a\b\u0012\u0004\u0012\u0002H;0\u0007\"\u0004\b\u0000\u0010;2\u0006\u00103\u001a\u0002042\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u000209\u0012\u0006\u0012\u0004\u0018\u0001H;08J\u0016\u0010=\u001a\u00020,2\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020,J2\u0010>\u001a\b\u0012\u0004\u0012\u0002H;0\u0007\"\u0004\b\u0000\u0010;2\u0006\u00103\u001a\u0002042\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u000209\u0012\u0006\u0012\u0004\u0018\u0001H;08H\u0002JH\u0010?\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u001f\u001a\u00020\b2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0!0!2\u001a\u0010*\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010#0\"0!H\u0002JH\u0010@\u001a\b\u0012\u0004\u0012\u00020%0\u00072\u0006\u0010\u001f\u001a\u00020\b2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0!0!2\u001a\u0010*\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010#0\"0!H\u0002J\u000e\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020CJ \u0010A\u001a\b\u0012\u0004\u0012\u0002H;0\u0007\"\u0004\b\u0000\u0010;2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H;0DJ!\u0010A\u001a\u0004\u0018\u0001H;\"\u0004\b\u0000\u0010;2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H;0E\u00a2\u0006\u0002\u0010FJ\u0015\u0010A\u001a\u0004\u0018\u00010%2\u0006\u0010B\u001a\u00020G\u00a2\u0006\u0002\u0010HJ\u000e\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020IJ1\u0010J\u001a\u0004\u0018\u0001H;\"\u0004\b\u0000\u0010;2\u0006\u00103\u001a\u0002042\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u000209\u0012\u0006\u0012\u0004\u0018\u0001H;08\u00a2\u0006\u0002\u0010KJ+\u0010L\u001a\u0002H;\"\u0004\b\u0000\u0010;2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u0002H;08H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010OJ\u000e\u0010P\u001a\u00020\f2\u0006\u00103\u001a\u000204J\u0015\u0010Q\u001a\u0004\u0018\u00010%2\u0006\u00103\u001a\u000204\u00a2\u0006\u0002\u0010RJ\b\u0010S\u001a\u00020)H\u0002J\u001e\u0010T\u001a\u00020)*\u00020,2\u0006\u0010U\u001a\u00020\f2\b\u0010V\u001a\u0004\u0018\u00010#H\u0002J+\u0010W\u001a\u00020)\"\u0006\b\u0000\u0010X\u0018\u0001*\u00020,2\u0006\u0010U\u001a\u00020\f2\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002HX0ZH\u0082\bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006["}, d2={"Lkotliquery/Session;", "Ljava/io/Closeable;", "connection", "Lkotliquery/Connection;", "returnGeneratedKeys", "", "autoGeneratedKeys", "", "", "transactional", "strict", "queryTimeout", "", "(Lkotliquery/Connection;ZLjava/util/List;ZZLjava/lang/Integer;)V", "getAutoGeneratedKeys", "()Ljava/util/List;", "getConnection", "()Lkotliquery/Connection;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getQueryTimeout", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getReturnGeneratedKeys", "()Z", "getStrict", "getTransactional", "setTransactional", "(Z)V", "batchPreparedNamedStatement", "statement", "params", "", "", "", "batchPreparedNamedStatementAndReturnGeneratedKeys", "", "batchPreparedStatement", "batchPreparedStatementAndReturnGeneratedKeys", "batchUpdates", "", "namedParams", "stmt", "Ljava/sql/PreparedStatement;", "close", "createArrayOf", "Ljava/sql/Array;", "typeName", "items", "createPreparedStatement", "query", "Lkotliquery/Query;", "execute", "forEach", "operator", "Lkotlin/Function1;", "Lkotliquery/Row;", "list", "A", "extractor", "populateParams", "rows", "rowsBatched", "rowsBatchedReturningGeneratedKeys", "run", "action", "Lkotliquery/action/ExecuteQueryAction;", "Lkotliquery/action/ListResultQueryAction;", "Lkotliquery/action/NullableResultQueryAction;", "(Lkotliquery/action/NullableResultQueryAction;)Ljava/lang/Object;", "Lkotliquery/action/UpdateAndReturnGeneratedKeyQueryAction;", "(Lkotliquery/action/UpdateAndReturnGeneratedKeyQueryAction;)Ljava/lang/Long;", "Lkotliquery/action/UpdateQueryAction;", "single", "(Lkotliquery/Query;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "transaction", "operation", "Lkotliquery/TransactionalSession;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "update", "updateAndReturnGeneratedKey", "(Lkotliquery/Query;)Ljava/lang/Long;", "warningForTransactionMode", "setParam", "idx", "v", "setTypedParam", "T", "param", "Lkotliquery/Parameter;", "kotliquery"})
public class Session
implements Closeable {
    @NotNull
    private final Connection connection;
    private final boolean returnGeneratedKeys;
    @NotNull
    private final List<String> autoGeneratedKeys;
    private boolean transactional;
    private final boolean strict;
    @Nullable
    private final Integer queryTimeout;
    private final Logger logger;

    public Session(@NotNull Connection connection, boolean returnGeneratedKeys, @NotNull List<String> autoGeneratedKeys, boolean transactional, boolean strict, @Nullable Integer queryTimeout) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(autoGeneratedKeys, (String)"autoGeneratedKeys");
        this.connection = connection;
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.transactional = transactional;
        this.strict = strict;
        this.queryTimeout = queryTimeout;
        this.logger = LoggerFactory.getLogger(Session.class);
    }

    public /* synthetic */ Session(Connection connection, boolean bl, List list, boolean bl2, boolean bl3, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        this(connection, bl, list, bl2, bl3, n);
    }

    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    public boolean getReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    @NotNull
    public List<String> getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public final boolean getTransactional() {
        return this.transactional;
    }

    public final void setTransactional(boolean bl) {
        this.transactional = bl;
    }

    public boolean getStrict() {
        return this.strict;
    }

    @Nullable
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void close() {
        this.transactional = false;
        this.getConnection().close();
    }

    private final /* synthetic */ <T> void setTypedParam(PreparedStatement $this$setTypedParam, int idx, Parameter<? extends T> param) {
        boolean $i$f$setTypedParam = false;
        if (param.getValue() == null) {
            $this$setTypedParam.setNull(idx, ParameterKt.sqlType(param));
        } else {
            this.setParam($this$setTypedParam, idx, param.getValue());
        }
    }

    private final void setParam(PreparedStatement $this$setParam, int idx, Object v) {
        if (v == null) {
            $this$setParam.setObject(idx, null);
        } else {
            Object object = v;
            if (object instanceof String) {
                $this$setParam.setString(idx, (String)v);
            } else if (object instanceof Byte) {
                $this$setParam.setByte(idx, ((Number)v).byteValue());
            } else if (object instanceof Boolean) {
                $this$setParam.setBoolean(idx, (Boolean)v);
            } else if (object instanceof Integer) {
                $this$setParam.setInt(idx, ((Number)v).intValue());
            } else if (object instanceof Long) {
                $this$setParam.setLong(idx, ((Number)v).longValue());
            } else if (object instanceof Short) {
                $this$setParam.setShort(idx, ((Number)v).shortValue());
            } else if (object instanceof Double) {
                $this$setParam.setDouble(idx, ((Number)v).doubleValue());
            } else if (object instanceof Float) {
                $this$setParam.setFloat(idx, ((Number)v).floatValue());
            } else if (object instanceof ZonedDateTime) {
                $this$setParam.setTimestamp(idx, Timestamp.from(((ZonedDateTime)v).toInstant()));
            } else if (object instanceof OffsetDateTime) {
                $this$setParam.setTimestamp(idx, Timestamp.from(((OffsetDateTime)v).toInstant()));
            } else if (object instanceof Instant) {
                $this$setParam.setTimestamp(idx, Timestamp.from((Instant)v));
            } else if (object instanceof LocalDateTime) {
                $this$setParam.setTimestamp(idx, Timestamp.valueOf((LocalDateTime)v));
            } else if (object instanceof LocalDate) {
                $this$setParam.setDate(idx, Date.valueOf((LocalDate)v));
            } else if (object instanceof java.time.LocalTime) {
                $this$setParam.setTime(idx, Time.valueOf((java.time.LocalTime)v));
            } else if (object instanceof DateTime) {
                $this$setParam.setTimestamp(idx, new Timestamp(((DateTime)v).getMillis()));
            } else if (object instanceof org.joda.time.LocalDateTime) {
                $this$setParam.setTimestamp(idx, new Timestamp(((org.joda.time.LocalDateTime)v).toDateTime().getMillis()));
            } else if (object instanceof org.joda.time.LocalDate) {
                $this$setParam.setDate(idx, new Date(((org.joda.time.LocalDate)v).toDateTimeAtStartOfDay().getMillis()));
            } else if (object instanceof LocalTime) {
                $this$setParam.setTime(idx, new Time(((LocalTime)v).toDateTimeToday().getMillis()));
            } else if (object instanceof Timestamp) {
                $this$setParam.setTimestamp(idx, (Timestamp)v);
            } else if (object instanceof Time) {
                $this$setParam.setTime(idx, (Time)v);
            } else if (object instanceof Date) {
                $this$setParam.setDate(idx, (Date)v);
            } else if (object instanceof SQLXML) {
                $this$setParam.setSQLXML(idx, (SQLXML)v);
            } else if (object instanceof java.util.Date) {
                $this$setParam.setTimestamp(idx, new Timestamp(((java.util.Date)v).getTime()));
            } else if (object instanceof byte[]) {
                $this$setParam.setBytes(idx, (byte[])v);
            } else if (object instanceof InputStream) {
                $this$setParam.setBinaryStream(idx, (InputStream)v);
            } else if (object instanceof BigDecimal) {
                $this$setParam.setBigDecimal(idx, (BigDecimal)v);
            } else if (object instanceof Array) {
                $this$setParam.setArray(idx, (Array)v);
            } else if (object instanceof URL) {
                $this$setParam.setURL(idx, (URL)v);
            } else {
                $this$setParam.setObject(idx, v);
            }
        }
    }

    @NotNull
    public final Array createArrayOf(@NotNull String typeName, @NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        java.sql.Connection connection = this.getConnection().getUnderlying();
        Collection<? extends Object> $this$toTypedArray$iv = items;
        boolean $i$f$toTypedArray = false;
        Collection<? extends Object> thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Array array = connection.createArrayOf(typeName, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)array, (String)"connection.underlying.cr\u2026me, items.toTypedArray())");
        return array;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PreparedStatement populateParams(@NotNull Query query, @NotNull PreparedStatement stmt) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        if (!query.getReplacementMap().isEmpty()) {
            query.getReplacementMap().forEach((arg_0, arg_1) -> Session.populateParams$lambda-1(this, stmt, query, arg_0, arg_1));
        } else {
            Iterable $this$forEachIndexed$iv = query.getParams();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void this_$iv;
                void idx$iv;
                void $this$setTypedParam$iv;
                void param$iv;
                Parameter parameter;
                void value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int index = n;
                boolean bl = false;
                Session session = this;
                PreparedStatement preparedStatement = stmt;
                int n2 = index + 1;
                Parameter $this$param$iv = value;
                boolean $i$f$param = false;
                if ($this$param$iv instanceof Parameter) {
                    Object t2 = ((Parameter)$this$param$iv).getValue();
                    Class clazz = ((Parameter)$this$param$iv).getType();
                    Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of kotliquery.ParameterKt.param>");
                    parameter = new Parameter(t2, clazz);
                } else {
                    parameter = new Parameter<Object>($this$param$iv, Object.class);
                }
                $this$param$iv = parameter;
                boolean $i$f$setTypedParam = false;
                if (param$iv.getValue() == null) {
                    $this$setTypedParam$iv.setNull((int)idx$iv, ParameterKt.sqlType(param$iv));
                    continue;
                }
                super.setParam((PreparedStatement)$this$setTypedParam$iv, (int)idx$iv, param$iv.getValue());
            }
        }
        return stmt;
    }

    @NotNull
    public final PreparedStatement createPreparedStatement(@NotNull Query query) {
        PreparedStatement stmt;
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (this.getReturnGeneratedKeys()) {
            if (Intrinsics.areEqual((Object)this.getConnection().getDriverName(), (Object)"oracle.jdbc.driver.OracleDriver")) {
                java.sql.Connection connection = this.getConnection().getUnderlying();
                String string = query.getCleanStatement();
                Collection $this$toTypedArray$iv = this.getAutoGeneratedKeys();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                preparedStatement = connection.prepareStatement(string, stringArray);
            } else {
                preparedStatement = this.getConnection().getUnderlying().prepareStatement(query.getCleanStatement(), 1);
            }
        } else {
            preparedStatement = stmt = this.getConnection().getUnderlying().prepareStatement(query.getCleanStatement());
        }
        if (this.getQueryTimeout() != null) {
            Integer n = this.getQueryTimeout();
            Intrinsics.checkNotNull((Object)n);
            stmt.setQueryTimeout(n);
        }
        Intrinsics.checkNotNullExpressionValue((Object)stmt, (String)"stmt");
        return this.populateParams(query, stmt);
    }

    private final <A> List<A> rows(Query query, Function1<? super Row, ? extends A> extractor) {
        return (List)LoanPattern.INSTANCE.using((AutoCloseable)this.createPreparedStatement(query), (Function1)new Function1<PreparedStatement, List<? extends A>>(extractor){
            final /* synthetic */ Function1<Row, A> $extractor;
            {
                this.$extractor = $extractor;
                super(1);
            }

            @NotNull
            public final List<A> invoke(@NotNull PreparedStatement stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                return (List)LoanPattern.INSTANCE.using((AutoCloseable)stmt.executeQuery(), (Function1)new Function1<ResultSet, List<? extends A>>(this.$extractor){
                    final /* synthetic */ Function1<Row, A> $extractor;
                    {
                        this.$extractor = $extractor;
                        super(1);
                    }

                    @NotNull
                    public final List<A> invoke(@NotNull ResultSet rs) {
                        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                        Sequence rows2 = SequencesKt.map((Sequence)new Row(rs, 0, 2, null), (Function1)((Function1)new Function1<Row, A>(this.$extractor){
                            final /* synthetic */ Function1<Row, A> $extractor;
                            {
                                this.$extractor = $extractor;
                                super(1);
                            }

                            @Nullable
                            public final A invoke(@NotNull Row row) {
                                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                                return (A)this.$extractor.invoke((Object)row);
                            }
                        }));
                        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)rows2, (Function1)rows.1.INSTANCE), (Function1)rows.2.INSTANCE));
                    }
                });
            }
        });
    }

    private final List<Integer> rowsBatched(String statement, Collection<? extends Collection<? extends Object>> params, Collection<? extends Map<String, ? extends Object>> namedParams) {
        return (List)LoanPattern.INSTANCE.using((AutoCloseable)this.getConnection().getUnderlying().prepareStatement(new Query(statement, null, null, 6, null).getCleanStatement()), (Function1)new Function1<PreparedStatement, List<? extends Integer>>(this, namedParams, statement, params){
            final /* synthetic */ Session this$0;
            final /* synthetic */ Collection<Map<String, Object>> $namedParams;
            final /* synthetic */ String $statement;
            final /* synthetic */ Collection<Collection<Object>> $params;
            {
                this.this$0 = $receiver;
                this.$namedParams = $namedParams;
                this.$statement = $statement;
                this.$params = $params;
                super(1);
            }

            @NotNull
            public final List<Integer> invoke(@NotNull PreparedStatement stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                if (this.this$0.getQueryTimeout() != null) {
                    Integer n = this.this$0.getQueryTimeout();
                    Intrinsics.checkNotNull((Object)n);
                    stmt.setQueryTimeout(n);
                }
                Session.access$batchUpdates(this.this$0, this.$namedParams, this.$statement, stmt, this.$params);
                int[] nArray = stmt.executeBatch();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"stmt.executeBatch()");
                return ArraysKt.toList((int[])nArray);
            }
        });
    }

    private final List<Long> rowsBatchedReturningGeneratedKeys(String statement, Collection<? extends Collection<? extends Object>> params, Collection<? extends Map<String, ? extends Object>> namedParams) {
        return (List)LoanPattern.INSTANCE.using((AutoCloseable)this.getConnection().getUnderlying().prepareStatement(new Query(statement, null, null, 6, null).getCleanStatement(), 1), (Function1)new Function1<PreparedStatement, List<? extends Long>>(this, namedParams, statement, params){
            final /* synthetic */ Session this$0;
            final /* synthetic */ Collection<Map<String, Object>> $namedParams;
            final /* synthetic */ String $statement;
            final /* synthetic */ Collection<Collection<Object>> $params;
            {
                this.this$0 = $receiver;
                this.$namedParams = $namedParams;
                this.$statement = $statement;
                this.$params = $params;
                super(1);
            }

            @NotNull
            public final List<Long> invoke(@NotNull PreparedStatement stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                Session.access$batchUpdates(this.this$0, this.$namedParams, this.$statement, stmt, this.$params);
                if (this.this$0.getQueryTimeout() != null) {
                    Integer n = this.this$0.getQueryTimeout();
                    Intrinsics.checkNotNull((Object)n);
                    stmt.setQueryTimeout(n);
                }
                stmt.executeBatch();
                ResultSet generatedKeysRs = stmt.getGeneratedKeys();
                List keys = new ArrayList<E>();
                while (generatedKeysRs.next()) {
                    keys.add(generatedKeysRs.getLong(1));
                }
                if (keys.isEmpty()) {
                    Session.access$getLogger$p(this.this$0).warn("Unexpectedly, Statement#getGeneratedKeys doesn't have any elements for " + this.$statement);
                }
                return CollectionsKt.toList((Iterable)keys);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void batchUpdates(Collection<? extends Map<String, ? extends Object>> namedParams, String statement, PreparedStatement stmt, Collection<? extends Collection<? extends Object>> params) {
        if (!namedParams.isEmpty()) {
            Map<String, List<Integer>> extracted = Query.Companion.extractNamedParamsIndexed$kotliquery(statement);
            Iterable $this$forEach$iv = namedParams;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map paramRow = (Map)element$iv;
                boolean bl = false;
                extracted.forEach((arg_0, arg_1) -> Session.batchUpdates$lambda-5$lambda-4(this, stmt, paramRow, arg_0, arg_1));
                stmt.addBatch();
            }
        } else {
            Iterable $this$forEach$iv = params;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection paramsRow = (Collection)element$iv;
                boolean bl = false;
                Iterable $this$forEachIndexed$iv = paramsRow;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void this_$iv;
                    void idx$iv;
                    void $this$setTypedParam$iv;
                    void param$iv;
                    Parameter parameter;
                    void value;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv;
                    int idx = n;
                    boolean bl2 = false;
                    Session session = this;
                    PreparedStatement preparedStatement = stmt;
                    int n2 = idx + 1;
                    Parameter $this$param$iv = value;
                    boolean $i$f$param = false;
                    if ($this$param$iv instanceof Parameter) {
                        Object t2 = ((Parameter)$this$param$iv).getValue();
                        Class clazz = ((Parameter)$this$param$iv).getType();
                        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of kotliquery.ParameterKt.param>");
                        parameter = new Parameter(t2, clazz);
                    } else {
                        parameter = new Parameter<Object>($this$param$iv, Object.class);
                    }
                    $this$param$iv = parameter;
                    boolean $i$f$setTypedParam = false;
                    if (param$iv.getValue() == null) {
                        $this$setTypedParam$iv.setNull((int)idx$iv, ParameterKt.sqlType(param$iv));
                        continue;
                    }
                    super.setParam((PreparedStatement)$this$setTypedParam$iv, (int)idx$iv, param$iv.getValue());
                }
                stmt.addBatch();
            }
        }
    }

    private final void warningForTransactionMode() {
        if (this.transactional) {
            this.logger.warn("Use TransactionalSession instead. The `tx` of `session.transaction { tx -> ... }`");
        }
    }

    @Nullable
    public final <A> A single(@NotNull Query query, @NotNull Function1<? super Row, ? extends A> extractor) {
        Object object;
        block5: {
            List<A> rs;
            block4: {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
                this.warningForTransactionMode();
                rs = this.rows(query, extractor);
                if (!this.getStrict()) break block4;
                switch (rs.size()) {
                    case 1: {
                        object = CollectionsKt.first(rs);
                        break block5;
                    }
                    case 0: {
                        object = null;
                        break block5;
                    }
                    default: {
                        throw new SQLException("Expected 1 row but received " + rs.size() + '.');
                    }
                }
            }
            object = !((Collection)rs).isEmpty() ? CollectionsKt.first(rs) : null;
        }
        return (A)object;
    }

    @NotNull
    public final <A> List<A> list(@NotNull Query query, @NotNull Function1<? super Row, ? extends A> extractor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        this.warningForTransactionMode();
        return CollectionsKt.toList((Iterable)this.rows(query, extractor));
    }

    @NotNull
    public final List<Integer> batchPreparedNamedStatement(@NotNull String statement, @NotNull Collection<? extends Map<String, ? extends Object>> params) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.warningForTransactionMode();
        return this.rowsBatched(statement, CollectionsKt.emptyList(), params);
    }

    @NotNull
    public final List<Long> batchPreparedNamedStatementAndReturnGeneratedKeys(@NotNull String statement, @NotNull Collection<? extends Map<String, ? extends Object>> params) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.warningForTransactionMode();
        return this.rowsBatchedReturningGeneratedKeys(statement, CollectionsKt.emptyList(), params);
    }

    @NotNull
    public final List<Integer> batchPreparedStatement(@NotNull String statement, @NotNull Collection<? extends Collection<? extends Object>> params) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.warningForTransactionMode();
        return this.rowsBatched(statement, params, CollectionsKt.emptyList());
    }

    @NotNull
    public final List<Long> batchPreparedStatementAndReturnGeneratedKeys(@NotNull String statement, @NotNull Collection<? extends Collection<? extends Object>> params) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.warningForTransactionMode();
        return this.rowsBatchedReturningGeneratedKeys(statement, params, CollectionsKt.emptyList());
    }

    public final void forEach(@NotNull Query query, @NotNull Function1<? super Row, Unit> operator) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.warningForTransactionMode();
        LoanPattern.INSTANCE.using((AutoCloseable)this.createPreparedStatement(query), (Function1)new Function1<PreparedStatement, Unit>(operator){
            final /* synthetic */ Function1<Row, Unit> $operator;
            {
                this.$operator = $operator;
                super(1);
            }

            public final void invoke(@NotNull PreparedStatement stmt) {
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                LoanPattern.INSTANCE.using((AutoCloseable)stmt.executeQuery(), (Function1)new Function1<ResultSet, Unit>(this.$operator){
                    final /* synthetic */ Function1<Row, Unit> $operator;
                    {
                        this.$operator = $operator;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ResultSet rs) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                        Sequence sequence = new Row(rs, 0, 2, null);
                        Function1<Row, Unit> function1 = this.$operator;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            Row row = (Row)element$iv;
                            boolean bl = false;
                            function1.invoke((Object)row);
                        }
                    }
                });
            }
        });
    }

    public final boolean execute(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.warningForTransactionMode();
        return (Boolean)LoanPattern.INSTANCE.using((AutoCloseable)this.createPreparedStatement(query), execute.1.INSTANCE);
    }

    public final int update(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.warningForTransactionMode();
        return ((Number)LoanPattern.INSTANCE.using((AutoCloseable)this.createPreparedStatement(query), update.1.INSTANCE)).intValue();
    }

    @Nullable
    public final Long updateAndReturnGeneratedKey(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.warningForTransactionMode();
        return (Long)LoanPattern.INSTANCE.using((AutoCloseable)this.createPreparedStatement(query), (Function1)new Function1<PreparedStatement, Long>(this, query){
            final /* synthetic */ Session this$0;
            final /* synthetic */ Query $query;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                super(1);
            }

            @Nullable
            public final Long invoke(@NotNull PreparedStatement stmt) {
                Long l;
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                if (stmt.executeUpdate() > 0) {
                    ResultSet rs = stmt.getGeneratedKeys();
                    boolean hasNext = rs.next();
                    if (!hasNext) {
                        Session.access$getLogger$p(this.this$0).warn("Unexpectedly, Statement#getGeneratedKeys doesn't have any elements for " + this.$query.getStatement());
                    }
                    l = rs.getLong(1);
                } else {
                    l = null;
                }
                return l;
            }
        });
    }

    public final boolean run(@NotNull ExecuteQueryAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return action.runWithSession(this);
    }

    public final int run(@NotNull UpdateQueryAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return action.runWithSession(this);
    }

    @Nullable
    public final Long run(@NotNull UpdateAndReturnGeneratedKeyQueryAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return action.runWithSession(this);
    }

    @NotNull
    public final <A> List<A> run(@NotNull ListResultQueryAction<A> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return action.runWithSession(this);
    }

    @Nullable
    public final <A> A run(@NotNull NullableResultQueryAction<A> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return action.runWithSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <A> A transaction(@NotNull Function1<? super TransactionalSession, ? extends A> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$transaction = false;
        try {
            this.getConnection().begin();
            this.setTransactional(true);
            TransactionalSession tx = new TransactionalSession(this.getConnection(), this.getReturnGeneratedKeys(), this.getAutoGeneratedKeys(), this.getStrict());
            Object result = operation.invoke((Object)tx);
            this.getConnection().commit();
            Object object = result;
            return (A)object;
        }
        catch (Exception e) {
            this.getConnection().rollback();
            throw e;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.setTransactional(false);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void populateParams$lambda-1(Session this$0, PreparedStatement $stmt, Query $query, String paramName, List occurrences) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stmt, (String)"$stmt");
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)occurrences, (String)"occurrences");
        Iterable $this$forEach$iv = occurrences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            void idx$iv;
            void $this$setTypedParam$iv;
            void param$iv;
            Parameter parameter;
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            Session session = this$0;
            PreparedStatement preparedStatement = $stmt;
            int n = it + 1;
            Object $this$param$iv = $query.getParamMap().get(paramName);
            boolean $i$f$param = false;
            if ($this$param$iv instanceof Parameter) {
                Object t = ((Parameter)$this$param$iv).getValue();
                Class clazz = ((Parameter)$this$param$iv).getType();
                Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of kotliquery.ParameterKt.param>");
                parameter = new Parameter(t, clazz);
            } else {
                parameter = new Parameter<Object>($this$param$iv, Object.class);
            }
            $this$param$iv = parameter;
            boolean $i$f$setTypedParam = false;
            if (param$iv.getValue() == null) {
                $this$setTypedParam$iv.setNull((int)idx$iv, ParameterKt.sqlType(param$iv));
                continue;
            }
            super.setParam((PreparedStatement)$this$setTypedParam$iv, (int)idx$iv, param$iv.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void batchUpdates$lambda-5$lambda-4(Session this$0, PreparedStatement $stmt, Map $paramRow, String paramName, List occurrences) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stmt, (String)"$stmt");
        Intrinsics.checkNotNullParameter((Object)$paramRow, (String)"$paramRow");
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)occurrences, (String)"occurrences");
        Iterable $this$forEach$iv = occurrences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            void idx$iv;
            void $this$setTypedParam$iv;
            void param$iv;
            Parameter parameter;
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            Session session = this$0;
            PreparedStatement preparedStatement = $stmt;
            int n = it + 1;
            Object $this$param$iv = $paramRow.get(paramName);
            boolean $i$f$param = false;
            if ($this$param$iv instanceof Parameter) {
                Object t = ((Parameter)$this$param$iv).getValue();
                Class clazz = ((Parameter)$this$param$iv).getType();
                Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of kotliquery.ParameterKt.param>");
                parameter = new Parameter(t, clazz);
            } else {
                parameter = new Parameter<Object>($this$param$iv, Object.class);
            }
            $this$param$iv = parameter;
            boolean $i$f$setTypedParam = false;
            if (param$iv.getValue() == null) {
                $this$setTypedParam$iv.setNull((int)idx$iv, ParameterKt.sqlType(param$iv));
                continue;
            }
            super.setParam((PreparedStatement)$this$setTypedParam$iv, (int)idx$iv, param$iv.getValue());
        }
    }

    public static final /* synthetic */ void access$batchUpdates(Session $this, Collection namedParams, String statement, PreparedStatement stmt, Collection params) {
        $this.batchUpdates(namedParams, statement, stmt, params);
    }

    public static final /* synthetic */ Logger access$getLogger$p(Session $this) {
        return $this.logger;
    }
}

