/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.signedrequest4j;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class OAuthEncoding {
    private static Logger log = Logger.getLogger(OAuthEncoding.class);

    public static String encode(Object obj) {
        if (obj == null) {
            return "";
        }
        String encoded = obj.toString();
        try {
            encoded = URLEncoder.encode(obj.toString(), "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("input: " + obj.toString() + ", encoded: " + encoded));
        }
        return encoded;
    }

    public static String decode(String encoded) {
        if (encoded == null) {
            return "";
        }
        String decoded = encoded;
        try {
            decoded = URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("encoded: " + encoded + ", decoded: " + decoded));
        }
        return decoded;
    }

    public static String normalizeURL(String url) {
        try {
            String path;
            int index;
            boolean dropPort;
            URI uri = new URI(url);
            String scheme = uri.getScheme().toLowerCase();
            String authority = uri.getAuthority().toLowerCase();
            boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
            if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
                authority = authority.substring(0, index);
            }
            if ((path = uri.getRawPath()) == null || path.length() <= 0) {
                path = "/";
            }
            String normalizedURL = scheme + "://" + authority + path;
            if (log.isDebugEnabled()) {
                log.debug((Object)("normalizedURL: " + normalizedURL));
            }
            return normalizedURL;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred!", (Throwable)e);
            }
            return url;
        }
    }
}

