/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.signedrequest4j;

import com.github.seratch.signedrequest4j.HttpException;
import com.github.seratch.signedrequest4j.HttpMethod;
import com.github.seratch.signedrequest4j.HttpResponse;
import com.github.seratch.signedrequest4j.OAuthAccessToken;
import com.github.seratch.signedrequest4j.OAuthConsumer;
import com.github.seratch.signedrequest4j.OAuthRealm;
import com.github.seratch.signedrequest4j.RequestBody;
import com.github.seratch.signedrequest4j.SignatureMethod;
import com.github.seratch.signedrequest4j.SignedRequest;
import com.github.seratch.signedrequest4j.SignedRequestBaseImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class SignedRequestApacheHCImpl
extends SignedRequestBaseImpl
implements SignedRequest {
    public SignedRequestApacheHCImpl(OAuthRealm realm, OAuthConsumer consumer, SignatureMethod signatureMethod) {
        this(realm, consumer, null, signatureMethod);
    }

    public SignedRequestApacheHCImpl(OAuthRealm realm, OAuthConsumer consumer, SignatureMethod signatureMethod, Map<String, Object> additionalParameters) {
        this(realm, consumer, null, signatureMethod, additionalParameters);
    }

    public SignedRequestApacheHCImpl(OAuthRealm realm, OAuthConsumer consumer, OAuthAccessToken accessToken, SignatureMethod signatureMethod) {
        this.realm = realm;
        this.consumer = consumer;
        this.accessToken = accessToken;
        this.signatureMethod = signatureMethod;
    }

    public SignedRequestApacheHCImpl(OAuthRealm realm, OAuthConsumer consumer, OAuthAccessToken accessToken, SignatureMethod signatureMethod, Map<String, Object> additionalParameters) {
        this.realm = realm;
        this.consumer = consumer;
        this.accessToken = accessToken;
        this.signatureMethod = signatureMethod;
        this.additionalParameters = additionalParameters;
    }

    @Override
    public HttpResponse doRequest(String url, HttpMethod method, RequestBody body, String charset) throws IOException {
        BasicHttpEntity entity;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpUriRequest request = SignedRequestApacheHCImpl.getRequest(method, url);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)this.connectTimeoutMillis);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)this.readTimeoutMillis);
        httpClient.getParams().setParameter("http.useragent", (Object)"SignedRequest4J HTTP Fetcher (https://github.com/seratch/signedrequest4j)");
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        for (String name : this.headersToOverwrite.keySet()) {
            request.setHeader(name, (String)this.headersToOverwrite.get(name));
        }
        String oAuthNonce = String.valueOf(new SecureRandom().nextLong());
        Long oAuthTimestamp = System.currentTimeMillis() / 1000L;
        String signature = this.getSignature(url, method, oAuthNonce, oAuthTimestamp);
        String authorizationHeader = this.getAuthorizationHeader(signature, oAuthNonce, oAuthTimestamp);
        request.setHeader("Authorization", authorizationHeader);
        if (method == HttpMethod.POST) {
            HttpPost postRequest = (HttpPost)request;
            entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(body.getBody()));
            entity.setContentType(body.getContentType());
            postRequest.setEntity((HttpEntity)entity);
        } else if (method == HttpMethod.PUT) {
            HttpPut putRequest = (HttpPut)request;
            entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(body.getBody()));
            entity.setContentType(body.getContentType());
            putRequest.setEntity((HttpEntity)entity);
        }
        org.apache.http.HttpResponse apacheHCResponse = httpClient.execute(request);
        if (apacheHCResponse.getStatusLine().getStatusCode() >= 400) {
            HttpResponse httpResponse = SignedRequestApacheHCImpl.toReturnValue(apacheHCResponse, charset);
            throw new HttpException(apacheHCResponse.getStatusLine().getReasonPhrase(), httpResponse);
        }
        return SignedRequestApacheHCImpl.toReturnValue(apacheHCResponse, charset);
    }

    @Override
    public HttpResponse doRequest(String url, HttpMethod method, Map<String, Object> requestParameters, String charset) throws IOException {
        org.apache.http.HttpResponse apacheHCResponse;
        List<NameValuePair> params;
        UrlEncodedFormEntity entity = null;
        if (method == HttpMethod.GET) {
            params = SignedRequestApacheHCImpl.toNameValuePairList(requestParameters);
            String queryString = URLEncodedUtils.format(params, (String)"UTF-8");
            if (queryString != null && !queryString.isEmpty()) {
                url = url.contains("?") ? url + "&" + queryString : url + "?" + queryString;
            }
        } else {
            params = SignedRequestApacheHCImpl.toNameValuePairList(requestParameters);
            entity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        this.readQueryStringAndAddToSignatureBaseString(url);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpUriRequest request = SignedRequestApacheHCImpl.getRequest(method, url);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)this.connectTimeoutMillis);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)this.readTimeoutMillis);
        httpClient.getParams().setParameter("http.useragent", (Object)"SignedRequest4J HTTP Fetcher (https://github.com/seratch/signedrequest4j)");
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        for (String name : this.headersToOverwrite.keySet()) {
            request.setHeader(name, (String)this.headersToOverwrite.get(name));
        }
        String oAuthNonce = String.valueOf(new SecureRandom().nextLong());
        Long oAuthTimestamp = System.currentTimeMillis() / 1000L;
        String signature = this.getSignature(url, method, oAuthNonce, oAuthTimestamp);
        String authorizationHeader = this.getAuthorizationHeader(signature, oAuthNonce, oAuthTimestamp);
        request.setHeader("Authorization", authorizationHeader);
        if (entity != null) {
            if (method == HttpMethod.POST) {
                HttpPost postRequest = (HttpPost)request;
                postRequest.setEntity((HttpEntity)entity);
            } else if (method == HttpMethod.PUT) {
                HttpPut putRequest = (HttpPut)request;
                putRequest.setEntity((HttpEntity)entity);
            }
        }
        if ((apacheHCResponse = httpClient.execute(request)).getStatusLine().getStatusCode() >= 400) {
            HttpResponse httpResponse = SignedRequestApacheHCImpl.toReturnValue(apacheHCResponse, charset);
            throw new HttpException(apacheHCResponse.getStatusLine().getReasonPhrase(), httpResponse);
        }
        return SignedRequestApacheHCImpl.toReturnValue(apacheHCResponse, charset);
    }

    static List<NameValuePair> toNameValuePairList(Map<String, Object> params) {
        ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value == null) continue;
            nameValuePairList.add((NameValuePair)new BasicNameValuePair(key, value.toString()));
        }
        return nameValuePairList;
    }

    static HttpUriRequest getRequest(HttpMethod method, String url) {
        if (method == HttpMethod.GET) {
            return new HttpGet(url);
        }
        if (method == HttpMethod.POST) {
            return new HttpPost(url);
        }
        if (method == HttpMethod.PUT) {
            return new HttpPut(url);
        }
        if (method == HttpMethod.DELETE) {
            return new HttpDelete(url);
        }
        if (method == HttpMethod.HEAD) {
            return new HttpHead(url);
        }
        if (method == HttpMethod.OPTIONS) {
            return new HttpOptions(url);
        }
        if (method == HttpMethod.TRACE) {
            return new HttpTrace(url);
        }
        return null;
    }

    static HttpResponse toReturnValue(org.apache.http.HttpResponse response, String charset) throws IOException {
        Header[] headers;
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatusCode(response.getStatusLine().getStatusCode());
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header header : headers = response.getAllHeaders()) {
            responseHeaders.put(header.getName(), header.getValue());
        }
        httpResponse.setHeaders(responseHeaders);
        if (response.getEntity() != null) {
            httpResponse.setBody(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        }
        httpResponse.setCharset(charset);
        return httpResponse;
    }
}

