/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.signedrequest4j;

import com.github.seratch.signedrequest4j.Base64;
import com.github.seratch.signedrequest4j.HttpMethod;
import com.github.seratch.signedrequest4j.HttpResponse;
import com.github.seratch.signedrequest4j.NotString;
import com.github.seratch.signedrequest4j.OAuthAccessToken;
import com.github.seratch.signedrequest4j.OAuthConsumer;
import com.github.seratch.signedrequest4j.OAuthEncoding;
import com.github.seratch.signedrequest4j.OAuthRealm;
import com.github.seratch.signedrequest4j.RequestBody;
import com.github.seratch.signedrequest4j.SignatureMethod;
import com.github.seratch.signedrequest4j.SignedRequest;
import com.github.seratch.signedrequest4j.SignedRequestClientException;
import com.github.seratch.signedrequest4j.pem.PEMReader;
import com.github.seratch.signedrequest4j.pem.PKCS1EncodedKeySpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class SignedRequestBaseImpl
implements SignedRequest {
    protected static final String USER_AGENT = "SignedRequest4J HTTP Fetcher (https://github.com/seratch/signedrequest4j)";
    protected OAuthRealm realm;
    protected OAuthConsumer consumer;
    protected OAuthAccessToken accessToken;
    protected SignatureMethod signatureMethod;
    protected String oAuthVersion = "1.0";
    protected Map<String, Object> additionalParameters = new HashMap<String, Object>();
    protected Map<String, Object> getParameters = new HashMap<String, Object>();
    protected Map<String, Object> postParameters = new HashMap<String, Object>();
    protected String rsaPrivateKeyValue;
    protected int connectTimeoutMillis = 3000;
    protected int readTimeoutMillis = 10000;
    protected Map<String, String> headersToOverwrite = new HashMap<String, String>();

    @Override
    public Map<String, Object> getAdditionalAuthorizationHeaderParams() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalAuthorizationHeaderParams(Map<String, Object> additionalParams) {
        this.additionalParameters = additionalParams;
    }

    @Override
    public void setHeader(String name, String value) {
        this.headersToOverwrite.put(name, value);
    }

    @Override
    public SignedRequest setConnectTimeoutMillis(int millis) {
        this.connectTimeoutMillis = millis;
        return this;
    }

    @Override
    public SignedRequest setReadTimeoutMillis(int millis) {
        this.readTimeoutMillis = millis;
        return this;
    }

    @Override
    public SignedRequest setRsaPrivateKeyValue(String rsaPrivateKeyValue) {
        this.rsaPrivateKeyValue = rsaPrivateKeyValue;
        return this;
    }

    @Override
    public String getSignatureBaseString(String url, HttpMethod method, String oAuthNonce, Long oAuthTimestamp) {
        StringBuilder baseStringBuf = new StringBuilder();
        StringBuilder normalizedParamsBuf = new StringBuilder();
        for (Parameter param : this.getNormalizedParameters(oAuthNonce, oAuthTimestamp)) {
            if (normalizedParamsBuf.length() > 0) {
                normalizedParamsBuf.append("&");
            }
            normalizedParamsBuf.append(param.getKey());
            normalizedParamsBuf.append("=");
            normalizedParamsBuf.append(param.getValue());
        }
        baseStringBuf.append(OAuthEncoding.encode(method.toString().toUpperCase()));
        baseStringBuf.append("&");
        baseStringBuf.append(OAuthEncoding.encode(OAuthEncoding.normalizeURL(url)));
        baseStringBuf.append("&");
        baseStringBuf.append(OAuthEncoding.encode(normalizedParamsBuf.toString()));
        return baseStringBuf.toString();
    }

    @Override
    public String getSignature(String url, HttpMethod method, String oAuthNonce, Long oAuthTimestamp) {
        String baseString = this.getSignatureBaseString(url, method, oAuthNonce, oAuthTimestamp);
        if (this.signatureMethod == SignatureMethod.HMAC_SHA1) {
            String algorithm = "HmacSHA1";
            String consumerSecret = this.consumer.getConsumerSecret();
            String tokenSecret = this.accessToken != null && this.accessToken.getTokenSecret() != null ? this.accessToken.getTokenSecret() : "";
            String key = consumerSecret + "&" + tokenSecret;
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), algorithm);
            try {
                Mac mac = Mac.getInstance(algorithm);
                mac.init(keySpec);
                byte[] rawValue = mac.doFinal(baseString.getBytes());
                return Base64.encode(rawValue);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SignedRequestClientException("Invalid Alogrithm : " + e.getLocalizedMessage());
            }
            catch (InvalidKeyException e) {
                throw new SignedRequestClientException("Invalid key : " + e.getLocalizedMessage());
            }
        }
        if (this.signatureMethod == SignatureMethod.RSA_SHA1) {
            if (this.rsaPrivateKeyValue == null || this.rsaPrivateKeyValue.length() == 0) {
                throw new SignedRequestClientException("RSA Private Key value is required.");
            }
            try {
                PEMReader reader = new PEMReader(new ByteArrayInputStream(this.rsaPrivateKeyValue.getBytes("UTF-8")));
                byte[] bytes = reader.getDerBytes();
                KeySpec keySpec = null;
                if ("-----BEGIN RSA PRIVATE KEY-----".equals(reader.getBeginMarker())) {
                    keySpec = new PKCS1EncodedKeySpec(bytes).getKeySpec();
                } else if ("-----BEGIN PRIVATE KEY-----".equals(reader.getBeginMarker())) {
                    keySpec = new PKCS8EncodedKeySpec(bytes);
                } else {
                    throw new SignedRequestClientException("Invalid PEM file: Unknown marker for private key " + reader.getBeginMarker());
                }
                KeyFactory fac = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = fac.generatePrivate(keySpec);
                Signature signer = Signature.getInstance("SHA1withRSA");
                signer.initSign(privateKey);
                signer.update(baseString.getBytes());
                return Base64.encode(signer.sign());
            }
            catch (Exception e) {
                throw new SignedRequestClientException("Cannot make a signature(RSA)", e);
            }
        }
        if (this.signatureMethod == SignatureMethod.PLAINTEXT) {
            return baseString;
        }
        throw new SignedRequestClientException("Invalid Signature Method (oauth_signature_method) : " + this.signatureMethod.toString());
    }

    @Override
    public String getAuthorizationHeader(String signature, String oAuthNonce, Long oAuthTimestamp) {
        StringBuilder buf = new StringBuilder();
        buf.append("OAuth ");
        if (this.realm != null) {
            buf.append("realm=\"");
            buf.append(OAuthEncoding.encode(this.realm));
            buf.append("\",");
        }
        if (this.accessToken != null && this.accessToken.getToken() != null) {
            buf.append("oauth_token=\"");
            buf.append(OAuthEncoding.encode(this.accessToken.getToken()));
            buf.append("\",");
        }
        buf.append("oauth_consumer_key=\"");
        buf.append(OAuthEncoding.encode(this.consumer.getConsumerKey()));
        buf.append("\",");
        buf.append("oauth_signature_method=\"");
        buf.append(OAuthEncoding.encode((Object)this.signatureMethod));
        buf.append("\",");
        buf.append("oauth_signature=\"");
        buf.append(OAuthEncoding.encode(signature));
        buf.append("\",");
        buf.append("oauth_timestamp=\"");
        buf.append(OAuthEncoding.encode(oAuthTimestamp));
        buf.append("\",");
        buf.append("oauth_nonce=\"");
        buf.append(OAuthEncoding.encode(oAuthNonce));
        buf.append("\",");
        buf.append("oauth_version=\"");
        buf.append(OAuthEncoding.encode(this.oAuthVersion));
        buf.append("\"");
        if (this.additionalParameters != null && this.additionalParameters.size() > 0) {
            for (String key : this.additionalParameters.keySet()) {
                buf.append(",");
                buf.append(OAuthEncoding.encode(key));
                buf.append("=\"");
                buf.append(OAuthEncoding.encode(this.additionalParameters.get(key)));
                buf.append("\"");
            }
        }
        return buf.toString();
    }

    @Override
    public void readQueryStringAndAddToSignatureBaseString(String url) {
        String[] urlAndQueryString = url.split("\\?");
        if (urlAndQueryString.length == 2) {
            String[] params;
            String queryString = urlAndQueryString[1];
            for (String param : params = queryString.split("&")) {
                String[] keyAndValue = param.split("=");
                if (keyAndValue.length != 2) continue;
                try {
                    String key = null;
                    String value = null;
                    try {
                        key = URLDecoder.decode(keyAndValue[0], "UTF-8");
                        value = URLDecoder.decode(keyAndValue[1], "UTF-8");
                    }
                    catch (IllegalArgumentException ignore) {
                        // empty catch block
                    }
                    if (key == null) {
                        key = keyAndValue[0];
                    }
                    if (value == null) {
                        value = keyAndValue[1];
                    }
                    this.getParameters.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
    }

    protected List<Parameter> getNormalizedParameters(String oAuthNonce, Long oAuthTimestamp) {
        Object parameter;
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("oauth_consumer_key", this.consumer.getConsumerKey()));
        if (this.accessToken != null) {
            params.add(new Parameter("oauth_token", this.accessToken.getToken()));
        }
        params.add(new Parameter("oauth_nonce", oAuthNonce));
        params.add(new Parameter("oauth_signature_method", (Object)this.signatureMethod));
        params.add(new Parameter("oauth_timestamp", oAuthTimestamp));
        params.add(new Parameter("oauth_version", this.oAuthVersion));
        if (this.additionalParameters != null && this.additionalParameters.size() > 0) {
            for (String key : this.additionalParameters.keySet()) {
                parameter = this.additionalParameters.get(key);
                if (parameter == null) continue;
                params.add(new Parameter(key, OAuthEncoding.encode(parameter)));
            }
        }
        if (this.getParameters != null && this.getParameters.size() > 0) {
            for (String key : this.getParameters.keySet()) {
                parameter = this.getParameters.get(key);
                if (parameter == null) continue;
                params.add(new Parameter(key, OAuthEncoding.encode(parameter)));
            }
        }
        if (this.postParameters != null && this.postParameters.size() > 0) {
            for (String key : this.postParameters.keySet()) {
                parameter = this.postParameters.get(key);
                if (parameter == null) continue;
                params.add(new Parameter(key, OAuthEncoding.encode(parameter)));
            }
        }
        Collections.sort(params, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter p1, Parameter p2) {
                return p1.getKey().compareTo(p2.getKey());
            }
        });
        return params;
    }

    @Override
    public HttpResponse doGet(String url, String charset) throws IOException {
        return this.doRequest(url, HttpMethod.GET, new HashMap<String, Object>(), charset);
    }

    @Override
    public HttpResponse doHead(String url) throws IOException {
        return this.doRequest(url, HttpMethod.HEAD, new HashMap<String, Object>(), null);
    }

    @Override
    public HttpResponse doOptions(String url) throws IOException {
        return this.doRequest(url, HttpMethod.OPTIONS, new HashMap<String, Object>(), null);
    }

    @Override
    public HttpResponse doPost(String url, Map<String, Object> requestParameters, String charset) throws IOException {
        for (String key : requestParameters.keySet()) {
            if (requestParameters.get(key) == null) continue;
            this.postParameters.put(key, requestParameters.get(key));
        }
        return this.doRequest(url, HttpMethod.POST, requestParameters, charset);
    }

    @Override
    public HttpResponse doPost(String url, RequestBody body, String charset) throws IOException {
        return this.doRequest(url, HttpMethod.POST, body, charset);
    }

    @Override
    public HttpResponse doDelete(String url, Map<String, Object> requestParameters, String charset) throws IOException {
        return this.doRequest(url, HttpMethod.DELETE, requestParameters, charset);
    }

    @Override
    public HttpResponse doDelete(String url, RequestBody body, String charset) throws IOException {
        return this.doRequest(url, HttpMethod.DELETE, body, charset);
    }

    @Override
    public HttpResponse doPut(String url, Map<String, Object> requestParameters, String charset) throws IOException {
        return this.doRequest(url, HttpMethod.PUT, requestParameters, charset);
    }

    @Override
    public HttpResponse doPut(String url, RequestBody body, String charset) throws IOException {
        return this.doRequest(url, HttpMethod.PUT, body, charset);
    }

    @Override
    public HttpResponse doTrace(String url) throws IOException {
        return this.doRequest(url, HttpMethod.TRACE, new HashMap<String, Object>(), null);
    }

    protected static class Parameter {
        private final String key;
        private final Object value;

        public Parameter(String key, Object value) {
            this.key = key;
            if (value instanceof NotString) {
                throw new IllegalArgumentException("Invalid parameter value");
            }
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

