/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.signedrequest4j;

import com.github.seratch.signedrequest4j.HttpException;
import com.github.seratch.signedrequest4j.HttpMethod;
import com.github.seratch.signedrequest4j.HttpResponse;
import com.github.seratch.signedrequest4j.OAuthAccessToken;
import com.github.seratch.signedrequest4j.OAuthConsumer;
import com.github.seratch.signedrequest4j.OAuthRealm;
import com.github.seratch.signedrequest4j.RequestBody;
import com.github.seratch.signedrequest4j.SignatureMethod;
import com.github.seratch.signedrequest4j.SignedRequest;
import com.github.seratch.signedrequest4j.SignedRequestBaseImpl;
import httpilot.HTTP;
import httpilot.HTTPIOException;
import httpilot.Method;
import httpilot.Request;
import httpilot.Response;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Map;

public class SignedRequestHTTPilotImpl
extends SignedRequestBaseImpl
implements SignedRequest {
    public SignedRequestHTTPilotImpl(OAuthRealm realm, OAuthConsumer consumer, SignatureMethod signatureMethod) {
        this(realm, consumer, null, signatureMethod);
    }

    public SignedRequestHTTPilotImpl(OAuthRealm realm, OAuthConsumer consumer, SignatureMethod signatureMethod, Map<String, Object> additionalParameters) {
        this(realm, consumer, null, signatureMethod, additionalParameters);
    }

    public SignedRequestHTTPilotImpl(OAuthRealm realm, OAuthConsumer consumer, OAuthAccessToken accessToken, SignatureMethod signatureMethod) {
        this.realm = realm;
        this.consumer = consumer;
        this.accessToken = accessToken;
        this.signatureMethod = signatureMethod;
    }

    public SignedRequestHTTPilotImpl(OAuthRealm realm, OAuthConsumer consumer, OAuthAccessToken accessToken, SignatureMethod signatureMethod, Map<String, Object> additionalParameters) {
        this.realm = realm;
        this.consumer = consumer;
        this.accessToken = accessToken;
        this.signatureMethod = signatureMethod;
        this.additionalParameters = additionalParameters;
    }

    @Override
    public HttpResponse doRequest(String url, HttpMethod method, RequestBody body, String charset) throws IOException {
        Request request = new Request(url);
        this.readQueryStringAndAddToSignatureBaseString(url);
        request.setEnableThrowingIOException(true);
        request.setUserAgent("SignedRequest4J HTTP Fetcher (https://github.com/seratch/signedrequest4j)");
        request.setConnectTimeoutMillis(this.connectTimeoutMillis);
        request.setReadTimeoutMillis(this.readTimeoutMillis);
        request.setCharset(charset);
        for (String name : this.headersToOverwrite.keySet()) {
            request.setHeader(name, (String)this.headersToOverwrite.get(name));
        }
        String oAuthNonce = String.valueOf(new SecureRandom().nextLong());
        Long oAuthTimestamp = System.currentTimeMillis() / 1000L;
        String signature = this.getSignature(url, method, oAuthNonce, oAuthTimestamp);
        String authorizationHeader = this.getAuthorizationHeader(signature, oAuthNonce, oAuthTimestamp);
        request.setHeader("Authorization", authorizationHeader);
        request.setBody(body.getBody(), body.getContentType());
        try {
            Response response = HTTP.request((Method)new Method(method.name()), (Request)request);
            return SignedRequestHTTPilotImpl.toReturnValue(response);
        }
        catch (HTTPIOException ex) {
            HttpResponse httpResponse = SignedRequestHTTPilotImpl.toReturnValue(ex.getResponse());
            throw new HttpException(ex.getMessage(), httpResponse);
        }
    }

    @Override
    public HttpResponse doRequest(String url, HttpMethod method, Map<String, Object> requestParameters, String charset) throws IOException {
        Request request = new Request(url);
        request.setEnableThrowingIOException(true);
        request.setUserAgent("SignedRequest4J HTTP Fetcher (https://github.com/seratch/signedrequest4j)");
        request.setConnectTimeoutMillis(this.connectTimeoutMillis);
        request.setReadTimeoutMillis(this.readTimeoutMillis);
        request.setCharset(charset);
        for (String name : this.headersToOverwrite.keySet()) {
            request.setHeader(name, (String)this.headersToOverwrite.get(name));
        }
        if (method == HttpMethod.GET) {
            request.setQueryParams(requestParameters);
        } else {
            request.setFormParams(requestParameters);
        }
        this.readQueryStringAndAddToSignatureBaseString(request.getUrl());
        this.readQueryStringAndAddToSignatureBaseString(request.getQueryParams().toString());
        String oAuthNonce = String.valueOf(new SecureRandom().nextLong());
        Long oAuthTimestamp = System.currentTimeMillis() / 1000L;
        String signature = this.getSignature(url, method, oAuthNonce, oAuthTimestamp);
        String authorizationHeader = this.getAuthorizationHeader(signature, oAuthNonce, oAuthTimestamp);
        request.setHeader("Authorization", authorizationHeader);
        try {
            Response response = HTTP.request((Method)new Method(method.name()), (Request)request);
            return SignedRequestHTTPilotImpl.toReturnValue(response);
        }
        catch (HTTPIOException ex) {
            HttpResponse httpResponse = SignedRequestHTTPilotImpl.toReturnValue(ex.getResponse());
            throw new HttpException(ex.getMessage(), httpResponse);
        }
    }

    static HttpResponse toReturnValue(Response response) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatusCode(response.getStatus());
        httpResponse.setHeaders(response.getHeaders());
        httpResponse.setBody(response.getBody());
        httpResponse.setCharset(response.getCharset());
        return httpResponse;
    }
}

