/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.signedrequest4j;

import com.github.seratch.signedrequest4j.HttpMethod;
import com.github.seratch.signedrequest4j.OAuthAccessToken;
import com.github.seratch.signedrequest4j.OAuthConsumer;
import com.github.seratch.signedrequest4j.OAuthEncoding;
import com.github.seratch.signedrequest4j.SignatureMethod;
import com.github.seratch.signedrequest4j.SignedRequest;
import com.github.seratch.signedrequest4j.SignedRequestFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SignedRequestVerifier {
    private static Logger log = Logger.getLogger(SignedRequestVerifier.class);
    private static final Set<String> oAuthElementNames = new HashSet<String>();

    public static Map<String, String> parseAuthorizationHeader(String authorizationHeader) {
        String[] keyAndValueArray;
        HashMap<String, String> urlDecodedElements = new HashMap<String, String>();
        for (String keyAndValue : keyAndValueArray = authorizationHeader.split(",")) {
            String[] arr = keyAndValue.split("=");
            String key = arr[0].trim().replaceAll("\"", "");
            String value = arr[1].trim().replaceAll("\"", "");
            urlDecodedElements.put(key, OAuthEncoding.decode(value));
        }
        return urlDecodedElements;
    }

    public static boolean verifyHMacGetRequest(String url, String queryString, String authorizationHeader, OAuthConsumer consumer) {
        return SignedRequestVerifier.verify(url, queryString, authorizationHeader, consumer, HttpMethod.GET, SignatureMethod.HMAC_SHA1);
    }

    public static boolean verifyHMacPostRequest(String url, String queryString, String authorizationHeader, OAuthConsumer consumer) {
        return SignedRequestVerifier.verify(url, queryString, authorizationHeader, consumer, HttpMethod.POST, SignatureMethod.HMAC_SHA1);
    }

    @Deprecated
    public static boolean verifyLegacyUncorrected(String url, String authorizationHeader, OAuthConsumer consumer, HttpMethod httpMethod, SignatureMethod signatureMethod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizationHeader: " + authorizationHeader));
        }
        if (authorizationHeader == null) {
            return false;
        }
        Map<String, String> urlDecodedElements = SignedRequestVerifier.parseAuthorizationHeader(authorizationHeader);
        SignedRequest req = SignedRequestFactory.create(consumer, signatureMethod);
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        for (String name : urlDecodedElements.keySet()) {
            String _name = name.replaceFirst("OAuth\\s+", "");
            if (oAuthElementNames.contains(_name)) continue;
            additionalParams.put(name, urlDecodedElements.get(name));
        }
        req.setAdditionalAuthorizationHeaderParams(additionalParams);
        String nonce = urlDecodedElements.get("oauth_nonce");
        Long timestamp = Long.valueOf(urlDecodedElements.get("oauth_timestamp"));
        String signature = req.getSignature(url, httpMethod, nonce, timestamp);
        SignedRequestVerifier.debugLogSignature(signature, signatureMethod, urlDecodedElements);
        return signature.equals(urlDecodedElements.get("oauth_signature"));
    }

    public static boolean verify(String url, String queryString, String authorizationHeader, OAuthConsumer consumer, HttpMethod httpMethod, SignatureMethod signatureMethod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizationHeader: " + authorizationHeader));
        }
        if (authorizationHeader == null) {
            return false;
        }
        if (httpMethod.equals((Object)HttpMethod.POST)) {
            throw new IllegalArgumentException("Please use verifyPOST instead for POST requests.");
        }
        Map<String, String> urlDecodedElements = SignedRequestVerifier.parseAuthorizationHeader(authorizationHeader);
        SignedRequest req = SignedRequestFactory.create(consumer, signatureMethod);
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        for (String name : urlDecodedElements.keySet()) {
            String _name = name.replaceFirst("OAuth\\s+", "");
            if (oAuthElementNames.contains(_name)) continue;
            additionalParams.put(name, urlDecodedElements.get(name));
        }
        req.setAdditionalAuthorizationHeaderParams(additionalParams);
        String nonce = urlDecodedElements.get("oauth_nonce");
        Long timestamp = Long.valueOf(urlDecodedElements.get("oauth_timestamp"));
        if (queryString == null) {
            queryString = "";
        }
        req.readQueryStringAndAddToSignatureBaseString(url + "?" + queryString);
        String signature = req.getSignature(url, httpMethod, nonce, timestamp);
        SignedRequestVerifier.debugLogSignature(signature, signatureMethod, urlDecodedElements);
        return signature.equals(urlDecodedElements.get("oauth_signature"));
    }

    public static boolean verifyPOST(String url, String queryString, String authorizationHeader, OAuthConsumer consumer, SignatureMethod signatureMethod, Map<String, String> formParams) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizationHeader: " + authorizationHeader));
        }
        if (authorizationHeader == null) {
            return false;
        }
        Map<String, String> urlDecodedElements = SignedRequestVerifier.parseAuthorizationHeader(authorizationHeader);
        if (formParams != null) {
            for (String key : formParams.keySet()) {
                String value = formParams.get(key);
                if (value == null) continue;
                urlDecodedElements.put(key, value);
            }
        }
        SignedRequest req = SignedRequestFactory.create(consumer, signatureMethod);
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        for (String name : urlDecodedElements.keySet()) {
            String _name = name.replaceFirst("OAuth\\s+", "");
            if (oAuthElementNames.contains(_name)) continue;
            additionalParams.put(name, urlDecodedElements.get(name));
        }
        req.setAdditionalAuthorizationHeaderParams(additionalParams);
        String nonce = urlDecodedElements.get("oauth_nonce");
        Long timestamp = Long.valueOf(urlDecodedElements.get("oauth_timestamp"));
        if (queryString == null) {
            queryString = "";
        }
        req.readQueryStringAndAddToSignatureBaseString(url + "?" + queryString);
        String signature = req.getSignature(url, HttpMethod.POST, nonce, timestamp);
        SignedRequestVerifier.debugLogSignature(signature, signatureMethod, urlDecodedElements);
        return signature.equals(urlDecodedElements.get("oauth_signature"));
    }

    public static boolean verifyHMacGetRequest(String url, String queryString, String authorizationHeader, OAuthConsumer consumer, OAuthAccessToken accessToken) {
        return SignedRequestVerifier.verify(url, queryString, authorizationHeader, consumer, accessToken, HttpMethod.GET, SignatureMethod.HMAC_SHA1);
    }

    public static boolean verifyHMacPostRequest(String url, String queryString, String authorizationHeader, OAuthConsumer consumer, OAuthAccessToken accessToken) {
        return SignedRequestVerifier.verify(url, queryString, authorizationHeader, consumer, accessToken, HttpMethod.POST, SignatureMethod.HMAC_SHA1);
    }

    @Deprecated
    public static boolean verifyLegacyUncorrected(String url, String authorizationHeader, OAuthConsumer consumer, OAuthAccessToken accessToken, HttpMethod httpMethod, SignatureMethod signatureMethod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizationHeader: " + authorizationHeader));
        }
        if (authorizationHeader == null) {
            return false;
        }
        Map<String, String> urlDecodedElements = SignedRequestVerifier.parseAuthorizationHeader(authorizationHeader);
        SignedRequest req = SignedRequestFactory.create(consumer, accessToken, signatureMethod);
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        for (String name : urlDecodedElements.keySet()) {
            String _name = name.replaceFirst("OAuth\\s+", "");
            if (oAuthElementNames.contains(_name)) continue;
            additionalParams.put(name, urlDecodedElements.get(name));
        }
        req.setAdditionalAuthorizationHeaderParams(additionalParams);
        String signature = req.getSignature(url, httpMethod, urlDecodedElements.get("oauth_nonce"), Long.valueOf(urlDecodedElements.get("oauth_timestamp")));
        SignedRequestVerifier.debugLogSignature(signature, signatureMethod, urlDecodedElements);
        return signature.equals(urlDecodedElements.get("oauth_signature"));
    }

    public static boolean verify(String url, String queryString, String authorizationHeader, OAuthConsumer consumer, OAuthAccessToken accessToken, HttpMethod httpMethod, SignatureMethod signatureMethod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizationHeader: " + authorizationHeader));
        }
        if (authorizationHeader == null) {
            return false;
        }
        if (httpMethod.equals((Object)HttpMethod.POST)) {
            throw new IllegalArgumentException("Please use verifyPOST instead for POST requests.");
        }
        Map<String, String> urlDecodedElements = SignedRequestVerifier.parseAuthorizationHeader(authorizationHeader);
        SignedRequest req = SignedRequestFactory.create(consumer, accessToken, signatureMethod);
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        for (String name : urlDecodedElements.keySet()) {
            String _name = name.replaceFirst("OAuth\\s+", "");
            if (oAuthElementNames.contains(_name)) continue;
            additionalParams.put(name, urlDecodedElements.get(name));
        }
        req.setAdditionalAuthorizationHeaderParams(additionalParams);
        if (queryString == null) {
            queryString = "";
        }
        req.readQueryStringAndAddToSignatureBaseString(url + "?" + queryString);
        String signature = req.getSignature(url, httpMethod, urlDecodedElements.get("oauth_nonce"), Long.valueOf(urlDecodedElements.get("oauth_timestamp")));
        SignedRequestVerifier.debugLogSignature(signature, signatureMethod, urlDecodedElements);
        return signature.equals(urlDecodedElements.get("oauth_signature"));
    }

    public static boolean verifyPOST(String url, String queryString, String authorizationHeader, OAuthConsumer consumer, OAuthAccessToken accessToken, SignatureMethod signatureMethod, Map<String, String> formParams) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizationHeader: " + authorizationHeader));
        }
        if (authorizationHeader == null) {
            return false;
        }
        Map<String, String> urlDecodedElements = SignedRequestVerifier.parseAuthorizationHeader(authorizationHeader);
        if (formParams != null) {
            for (String key : formParams.keySet()) {
                String value = formParams.get(key);
                if (value == null) continue;
                urlDecodedElements.put(key, value);
            }
        }
        SignedRequest req = SignedRequestFactory.create(consumer, accessToken, signatureMethod);
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        for (String name : urlDecodedElements.keySet()) {
            String _name = name.replaceFirst("OAuth\\s+", "");
            if (oAuthElementNames.contains(_name)) continue;
            additionalParams.put(name, urlDecodedElements.get(name));
        }
        req.setAdditionalAuthorizationHeaderParams(additionalParams);
        if (queryString == null) {
            queryString = "";
        }
        req.readQueryStringAndAddToSignatureBaseString(url + "?" + queryString);
        String signature = req.getSignature(url, HttpMethod.POST, urlDecodedElements.get("oauth_nonce"), Long.valueOf(urlDecodedElements.get("oauth_timestamp")));
        SignedRequestVerifier.debugLogSignature(signature, signatureMethod, urlDecodedElements);
        return signature.equals(urlDecodedElements.get("oauth_signature"));
    }

    private static void debugLogSignature(String signature, SignatureMethod signatureMethod, Map<String, String> urlDecodedElements) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signature by Verifier: " + signature + ", method: " + signatureMethod.toString()));
            log.debug((Object)("Signature in Authorization header: " + urlDecodedElements.get("oauth_signature")));
        }
    }

    static {
        oAuthElementNames.add("oauth_consumer_key");
        oAuthElementNames.add("oauth_signature_method");
        oAuthElementNames.add("oauth_signature");
        oAuthElementNames.add("oauth_timestamp");
        oAuthElementNames.add("oauth_nonce");
        oAuthElementNames.add("oauth_token");
        oAuthElementNames.add("oauth_version");
    }
}

