/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.hamcrest;

import com.github.seregamorph.hamcrest.TestLambdaUtils;
import com.github.seregamorph.hamcrest.ThrowingFunction;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public class MoreMatchers {
    public static <T> Matcher<T> notNull(final Matcher<T> matcher) {
        return new TypeSafeDiagnosingMatcher<T>(){

            protected boolean matchesSafely(T value, Description mismatchDescription) {
                mismatchDescription.appendText("is " + value);
                return value != null && matcher.matches(value);
            }

            public void describeTo(Description description) {
                description.appendText("to be not null and match ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static <U, V> Matcher<U> where(final ThrowingFunction<U, V> extractor, final Matcher<V> matcher) {
        return new TypeSafeMatcher<U>(){

            protected boolean matchesSafely(U item) {
                Object target;
                if (item == null) {
                    return false;
                }
                try {
                    target = extractor.apply(item);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                return matcher.matches(target);
            }

            protected void describeMismatchSafely(U item, Description mismatchDescription) {
                Object target;
                try {
                    target = item == null ? null : extractor.apply(item);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                matcher.describeMismatch(target, mismatchDescription);
            }

            public void describeTo(Description description) {
                description.appendText("Object that matches ").appendDescriptionOf((SelfDescribing)matcher);
                Method methodReference = TestLambdaUtils.unreferenceLambdaMethod(extractor);
                if (methodReference == null) {
                    description.appendText(" after being extracted");
                } else {
                    String shortDescription = TestLambdaUtils.getMethodShortReference(methodReference);
                    description.appendText(" after call " + shortDescription);
                }
            }
        };
    }

    public static <T> Matcher<T> predicate(final Predicate<T> predicate, final String expectedDescription) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                return predicate.test(item);
            }

            public void describeTo(Description description) {
                description.appendText(expectedDescription);
            }
        };
    }

    private MoreMatchers() {
    }
}

