/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.hamcrest;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class OptionalMatchers {
    public static <T> Matcher<Optional<T>> isPresent() {
        return new TypeSafeDiagnosingMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> value, Description mismatchDescription) {
                mismatchDescription.appendText("is " + value);
                return value.isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("to be present");
            }
        };
    }

    public static <T> Matcher<Optional<T>> isPresent(final Matcher<T> matcher) {
        return new TypeSafeDiagnosingMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> value, Description mismatchDescription) {
                mismatchDescription.appendText("is " + value);
                return value.isPresent() && matcher.matches(value.get());
            }

            public void describeTo(Description description) {
                description.appendText("to be present and match ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static <T> Matcher<Optional<T>> isEmpty() {
        return new TypeSafeDiagnosingMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> value, Description mismatchDescription) {
                mismatchDescription.appendText("is " + value);
                return !value.isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("to be empty");
            }
        };
    }

    private OptionalMatchers() {
    }
}

