/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.hamcrest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

class MethodUtils {
    static String getMethodShortReference(Method method) {
        try {
            if (method.isSynthetic()) {
                ClassPool pool = ClassPool.getDefault();
                CtClass ctClass = pool.get(method.getDeclaringClass().getCanonicalName());
                CtMethod ctMethod = ctClass.getDeclaredMethod(method.getName());
                int lineNumber = ctMethod.getMethodInfo().getLineNumber(0);
                return ctClass.getClassFile().getSourceFile() + ":" + lineNumber;
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }

    static String getConstructorShortReference(Constructor<?> constructor) {
        String parameterTypeNames = Stream.of(constructor.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", "));
        return constructor.getDeclaringClass().getSimpleName() + "(" + parameterTypeNames + ")";
    }

    private MethodUtils() {
    }
}

