/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.hamcrest;

import com.github.seregamorph.hamcrest.MethodUtils;
import com.github.seregamorph.hamcrest.TestLambdaUtils;
import com.github.seregamorph.hamcrest.ThrowingFunction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class MoreMatchers {
    public static <U, V> Matcher<U> where(final ThrowingFunction<U, V> extractor, final Matcher<V> matcher) {
        return new TypeSafeMatcher<U>(){

            protected boolean matchesSafely(U item) {
                Object target;
                if (item == null) {
                    return false;
                }
                try {
                    target = extractor.apply(item);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                return matcher.matches(target);
            }

            protected void describeMismatchSafely(U item, Description mismatchDescription) {
                Object target;
                try {
                    target = item == null ? null : extractor.apply(item);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                matcher.describeMismatch(target, mismatchDescription);
            }

            public void describeTo(Description description) {
                description.appendText("Object that matches ").appendDescriptionOf((SelfDescribing)matcher);
                Method methodReference = TestLambdaUtils.unreferenceLambdaMethod(extractor);
                if (methodReference != null) {
                    String shortDescription = MethodUtils.getMethodShortReference(methodReference);
                    description.appendText(" after call " + shortDescription);
                } else {
                    Constructor<?> constructorReference = TestLambdaUtils.unreferenceLambdaConstructor(extractor);
                    if (constructorReference != null) {
                        String shortDescription = MethodUtils.getConstructorShortReference(constructorReference);
                        description.appendText(" after call " + shortDescription);
                    } else {
                        description.appendText(" after being extracted");
                    }
                }
            }
        };
    }

    public static <T> Matcher<T> predicate(final Predicate<T> predicate, final String expectedDescription) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                return predicate.test(item);
            }

            public void describeTo(Description description) {
                description.appendText(expectedDescription);
            }
        };
    }

    private MoreMatchers() {
    }
}

