/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.hamcrest;

import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class OrderMatchers {
    public static <T> Matcher<Iterable<T>> strictOrdered(Comparator<? super T> comparator, String comparatorDescription) {
        return OrderMatchers.ordered(comparator, false, comparatorDescription);
    }

    public static <T> Matcher<Iterable<T>> strictOrdered(Comparator<? super T> comparator) {
        return OrderMatchers.strictOrdered(comparator, null);
    }

    public static <T extends Comparable<? super T>> Matcher<Iterable<T>> strictOrdered() {
        return OrderMatchers.strictOrdered(Comparator.naturalOrder(), "natural comparator");
    }

    public static <T> Matcher<Iterable<T>> softOrdered(Comparator<? super T> comparator, String comparatorDescription) {
        return OrderMatchers.ordered(comparator, true, comparatorDescription);
    }

    public static <T> Matcher<Iterable<T>> softOrdered(Comparator<? super T> comparator) {
        return OrderMatchers.softOrdered(comparator, null);
    }

    public static <T extends Comparable<? super T>> Matcher<Iterable<T>> softOrdered() {
        return OrderMatchers.softOrdered(Comparator.naturalOrder(), "natural comparator");
    }

    private static <T> Matcher<Iterable<T>> ordered(final Comparator<? super T> comparator, final boolean allowEqual, final @Nullable String comparatorDescription) {
        return new TypeSafeDiagnosingMatcher<Iterable<T>>(){

            protected boolean matchesSafely(Iterable<T> item, Description mismatchDescription) {
                Iterator iterator = item.iterator();
                if (!iterator.hasNext()) {
                    return true;
                }
                Object first = iterator.next();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    int result = comparator.compare(first, next);
                    if (result == 0 && !allowEqual) {
                        mismatchDescription.appendText("Found equal elements " + first + " and " + next);
                        return false;
                    }
                    if (result > 0) {
                        mismatchDescription.appendText("Found unordered elements " + first + " and " + next);
                        return false;
                    }
                    first = next;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText((allowEqual ? "Softly" : "Strictly") + " ordered by " + (comparatorDescription == null ? "comparator" : comparatorDescription));
            }
        };
    }

    private OrderMatchers() {
    }
}

