/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.hamcrest;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class TestLambdaUtils {
    @Nullable
    public static Method unreferenceLambdaMethod(Serializable lambda) {
        SerializedLambda serializedLambda = TestLambdaUtils.getSerializedLambda(lambda);
        if (serializedLambda != null && (serializedLambda.getImplMethodKind() == 5 || serializedLambda.getImplMethodKind() == 6)) {
            Class<?> cls = TestLambdaUtils.implClassForName(serializedLambda.getImplClass());
            Class[] argumentClasses = TestLambdaUtils.parseArgumentClasses(serializedLambda.getImplMethodSignature());
            return Stream.of(cls.getDeclaredMethods()).filter(method -> method.getName().equals(serializedLambda.getImplMethodName()) && Arrays.equals(method.getParameterTypes(), argumentClasses)).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public static Constructor<?> unreferenceLambdaConstructor(Serializable lambda) {
        SerializedLambda serializedLambda = TestLambdaUtils.getSerializedLambda(lambda);
        if (serializedLambda != null && serializedLambda.getImplMethodKind() == 8) {
            Class<?> cls = TestLambdaUtils.implClassForName(serializedLambda.getImplClass());
            Class[] argumentClasses = TestLambdaUtils.parseArgumentClasses(serializedLambda.getImplMethodSignature());
            return Stream.of(cls.getDeclaredConstructors()).filter(constructor -> Arrays.equals(constructor.getParameterTypes(), argumentClasses)).findFirst().orElse(null);
        }
        return null;
    }

    static Class<?>[] parseArgumentClasses(String implMethodSignature) {
        int parenthesesPos = implMethodSignature.indexOf(41);
        if (!implMethodSignature.startsWith("(") || parenthesesPos <= 0) {
            throw new IllegalStateException("Wrong format of implMethodSignature " + implMethodSignature);
        }
        String argGroup = implMethodSignature.substring(1, parenthesesPos);
        ArrayList classes = new ArrayList();
        for (String token : argGroup.split(";")) {
            if (token.isEmpty()) continue;
            classes.add(TestLambdaUtils.parseType(token, false));
        }
        return classes.toArray(new Class[0]);
    }

    private static Class<?> parseType(String typeName, boolean allowVoid) {
        if ("Z".equals(typeName)) {
            return Boolean.TYPE;
        }
        if ("B".equals(typeName)) {
            return Byte.TYPE;
        }
        if ("C".equals(typeName)) {
            return Character.TYPE;
        }
        if ("S".equals(typeName)) {
            return Short.TYPE;
        }
        if ("I".equals(typeName)) {
            return Integer.TYPE;
        }
        if ("J".equals(typeName)) {
            return Long.TYPE;
        }
        if ("F".equals(typeName)) {
            return Float.TYPE;
        }
        if ("D".equals(typeName)) {
            return Double.TYPE;
        }
        if ("V".equals(typeName)) {
            if (allowVoid) {
                return Void.TYPE;
            }
            throw new IllegalStateException("void (V) type is not allowed");
        }
        if (!typeName.startsWith("L")) {
            throw new IllegalStateException("Wrong format of argument type (should start with 'L'): " + typeName);
        }
        String implClassName = typeName.substring(1);
        return TestLambdaUtils.implClassForName(implClassName);
    }

    @Nullable
    private static SerializedLambda getSerializedLambda(Serializable lambda) {
        for (Class<?> cl = lambda.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)lambda, new Object[0]);
                if (replacement instanceof SerializedLambda) {
                    return (SerializedLambda)replacement;
                }
                break;
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to call writeReplace", e);
            }
        }
        return null;
    }

    private static Class<?> implClassForName(String implClassName) {
        String className = implClassName.replace('/', '.');
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load class " + implClassName, e);
        }
    }

    private TestLambdaUtils() {
    }
}

