/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import java.util.Stack;
import org.springframework.lang.Nullable;

public class CurrentTestContext {
    private static final ThreadLocal<Stack<Class<?>>> currentTestClass = new ThreadLocal();

    @Nullable
    public static String getCurrentTestClassName() {
        Stack<Class<?>> stack = currentTestClass.get();
        return stack == null ? null : stack.peek().getName();
    }

    static void pushCurrentTestClass(Class<?> testClass) {
        Stack<Class<Object>> stack = currentTestClass.get();
        if (stack == null) {
            stack = new Stack();
            currentTestClass.set(stack);
        }
        stack.push(testClass);
    }

    static void popCurrentTestClass() {
        Stack<Class<?>> stack = currentTestClass.get();
        if (stack != null) {
            stack.pop();
            if (stack.isEmpty()) {
                currentTestClass.remove();
            }
        }
    }

    private CurrentTestContext() {
    }
}

