/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.CurrentTestContext;
import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class SmartDirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(SmartDirtiesContextTestExecutionListener.class);

    public int getOrder() {
        return 3001;
    }

    public void beforeTestClass(TestContext testContext) {
        CurrentTestContext.pushCurrentTestClass(testContext.getTestClass());
        Class testClass = testContext.getTestClass();
        if (SmartDirtiesTestsSupport.isInnerClass(testClass)) {
            SmartDirtiesTestsSupport.verifyInnerClass(testClass);
        }
    }

    public void afterTestClass(TestContext testContext) {
        try {
            Class testClass = testContext.getTestClass();
            if (SmartDirtiesTestsSupport.isLastClassPerConfig(testClass)) {
                logger.info("markDirty (closing context) after {}", (Object)testClass.getName());
                testContext.markApplicationContextDirty(null);
            } else {
                logger.debug("Reusing context after {}", (Object)testClass.getName());
            }
        }
        finally {
            CurrentTestContext.popCurrentTestClass();
        }
    }
}

