/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.IntegrationTestFilter;
import com.github.seregamorph.testsmartcontext.TestClassExtractor;
import com.github.seregamorph.testsmartcontext.TestSortResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.BootstrapUtilsHelper;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestContextBootstrapper;

public class SmartDirtiesTestsSorter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final SmartDirtiesTestsSorter instance = SmartDirtiesTestsSorter.initInstance();

    private static SmartDirtiesTestsSorter initInstance() {
        ServiceLoader<SmartDirtiesTestsSorter> loader = ServiceLoader.load(SmartDirtiesTestsSorter.class, SmartDirtiesTestsSorter.class.getClassLoader());
        Iterator<SmartDirtiesTestsSorter> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return new SmartDirtiesTestsSorter();
    }

    public static SmartDirtiesTestsSorter getInstance() {
        return instance;
    }

    protected SmartDirtiesTestsSorter() {
    }

    public <T> TestSortResult sort(List<T> testItems, TestClassExtractor<? super T> testClassExtractor) {
        this.initialSort(testItems, testClassExtractor);
        IntegrationTestFilter integrationTestFilter = IntegrationTestFilter.getInstance();
        LinkedHashSet itClasses = new LinkedHashSet();
        LinkedHashSet nonItClasses = new LinkedHashSet();
        for (T t : testItems) {
            Class<?> testClass = testClassExtractor.getTestClass(t);
            if (itClasses.contains(testClass) || nonItClasses.contains(testClass)) continue;
            if (integrationTestFilter.isIntegrationTest(testClass)) {
                itClasses.add(testClass);
                continue;
            }
            nonItClasses.add(testClass);
        }
        if (!itClasses.isEmpty()) {
            this.logSuiteTests(testItems.size(), itClasses, nonItClasses, testClassExtractor.getItemType());
        }
        LinkedHashMap<MergedContextConfiguration, TestClasses> configToTests = new LinkedHashMap<MergedContextConfiguration, TestClasses>();
        LinkedHashMap<Class, Integer> classToOrder = new LinkedHashMap<Class, Integer>();
        AtomicInteger orderCounter = new AtomicInteger();
        for (Class clazz : itClasses) {
            MergedContextConfiguration mergedContextConfiguration;
            TestContextBootstrapper bootstrapper = BootstrapUtilsHelper.resolveTestContextBootstrapper(clazz);
            try {
                mergedContextConfiguration = bootstrapper.buildMergedContextConfiguration();
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Failed to build MergedContextConfiguration for " + clazz, e);
            }
            TestClasses testClasses2 = configToTests.computeIfAbsent(mergedContextConfiguration, $ -> new TestClasses(orderCounter.addAndGet(3), new LinkedHashSet()));
            testClasses2.classes.add(clazz);
            classToOrder.put(clazz, testClasses2.order);
        }
        testItems.sort(Comparator.comparing(testItem -> {
            Class<?> testClass = testClassExtractor.getTestClass(testItem);
            Integer order = (Integer)classToOrder.get(testClass);
            if (order == null) {
                return this.getNonItOrder();
            }
            return order + SmartDirtiesTestsSorter.getDirtiesContextBeforeAfterOrder(testClass);
        }));
        List<List<Class<?>>> sortedConfigToTests = configToTests.values().stream().map(testClasses -> ((TestClasses)testClasses).classes.stream().sorted(Comparator.comparing(SmartDirtiesTestsSorter::getDirtiesContextBeforeAfterOrder)).collect(Collectors.toList())).collect(Collectors.toList());
        if (!sortedConfigToTests.isEmpty()) {
            this.logSuiteTestsPerConfig(itClasses.size(), nonItClasses.size(), sortedConfigToTests);
        }
        return new TestSortResult(sortedConfigToTests, nonItClasses);
    }

    protected int getNonItOrder() {
        return 0;
    }

    protected <T> void initialSort(List<T> testItems, TestClassExtractor<? super T> testClassExtractor) {
        testItems.sort(Comparator.comparing(testItem -> testClassExtractor.getTestClass(testItem).getName()));
        if (Boolean.getBoolean("testsmartcontext.reverse")) {
            Collections.reverse(testItems);
        }
    }

    private static int getDirtiesContextBeforeAfterOrder(Class<?> testClass) {
        DirtiesContext dirtiesContext = (DirtiesContext)TestContextAnnotationUtils.findMergedAnnotation(testClass, DirtiesContext.class);
        if (dirtiesContext != null) {
            if (dirtiesContext.classMode() == DirtiesContext.ClassMode.BEFORE_CLASS) {
                return -1;
            }
            if (dirtiesContext.classMode() == DirtiesContext.ClassMode.AFTER_CLASS) {
                return 1;
            }
        }
        return 0;
    }

    private void logSuiteTests(int totalTests, Collection<Class<?>> itClasses, Collection<Class<?>> nonItClasses, TestClassExtractor.ItemType itemType) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("Running suite of " + totalTests + " " + (itemType == TestClassExtractor.ItemType.TEST_CLASS ? "test classes" : "test methods") + ". Integration test classes (" + itClasses.size() + " classes):");
        itClasses.forEach(pw::println);
        if (!nonItClasses.isEmpty()) {
            pw.println("Non-integration test classes (" + nonItClasses.size() + " classes):");
            nonItClasses.forEach(pw::println);
        }
        this.logger.debug(sw.toString());
    }

    private void logSuiteTestsPerConfig(int itClassesSize, int nonItClassesSize, List<List<Class<?>>> sortedConfigToTests) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("Running suite of " + (nonItClassesSize > 0 ? nonItClassesSize + " unit and " : "") + itClassesSize + " integration test classes grouped and reordered by their MergedContextConfiguration (" + sortedConfigToTests.size() + " groups):");
        sortedConfigToTests.forEach(itClasses -> {
            pw.println("---");
            boolean isFirst = true;
            Iterator it = itClasses.iterator();
            while (it.hasNext()) {
                boolean isLast;
                Class itClass = (Class)it.next();
                boolean bl = isLast = !it.hasNext();
                String suffix1 = isFirst && isLast ? "creates and closes context" : (isFirst ? "creates context" : (isLast ? "closes context" : null));
                DirtiesContext dirtiesContext = (DirtiesContext)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)itClass, DirtiesContext.class);
                String suffix2 = dirtiesContext == null ? null : "marked @DirtiesContext(" + dirtiesContext.classMode().name() + ")";
                pw.print(itClass.getName());
                if (suffix1 != null || suffix2 != null) {
                    pw.print(" (" + (suffix1 == null ? "" : suffix1 + (suffix2 == null ? "" : "; ")) + (suffix2 == null ? "" : suffix2) + ")");
                }
                pw.println();
                isFirst = false;
            }
        });
        System.out.println(sw);
    }

    private static final class TestClasses {
        private final int order;
        private final Set<Class<?>> classes;

        private TestClasses(int order, Set<Class<?>> classes) {
            this.order = order;
            this.classes = classes;
        }
    }
}

