/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import java.util.function.Function;

public abstract class TestClassExtractor<T> {
    private final ItemType itemType;

    protected TestClassExtractor(ItemType itemType) {
        this.itemType = itemType;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public static <T> TestClassExtractor<T> ofClass(final Function<T, Class<?>> testClassExtractor) {
        return new TestClassExtractor<T>(ItemType.TEST_CLASS){

            @Override
            public Class<?> getTestClass(T test) {
                return (Class)testClassExtractor.apply(test);
            }
        };
    }

    public static <T> TestClassExtractor<T> ofMethod(final Function<T, Class<?>> testClassExtractor) {
        return new TestClassExtractor<T>(ItemType.TEST_METHOD){

            @Override
            public Class<?> getTestClass(T test) {
                return (Class)testClassExtractor.apply(test);
            }
        };
    }

    public abstract Class<?> getTestClass(T var1);

    public static enum ItemType {
        TEST_CLASS,
        TEST_METHOD;

    }
}

