/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext.jdbc;

import java.io.Closeable;
import java.io.IOException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class CloseableDelegatingDataSource
extends DelegatingDataSource
implements Closeable {
    public CloseableDelegatingDataSource() {
    }

    public CloseableDelegatingDataSource(DataSource targetDataSource) {
        super(CloseableDelegatingDataSource.requireCloseable(targetDataSource));
    }

    private static DataSource requireCloseable(DataSource targetDataSource) {
        if (targetDataSource == null) {
            throw new IllegalArgumentException("targetDataSource is null");
        }
        if (!(targetDataSource instanceof Closeable)) {
            throw new IllegalArgumentException("targetDataSource is not closeable");
        }
        return targetDataSource;
    }

    @Override
    public void close() throws IOException {
        DataSource targetDataSource = this.getTargetDataSource();
        if (targetDataSource instanceof Closeable) {
            ((Closeable)((Object)targetDataSource)).close();
        }
    }
}

