/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext.testng;

import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSorter;
import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSupport;
import com.github.seregamorph.testsmartcontext.TestClassExtractor;
import com.github.seregamorph.testsmartcontext.TestSortResult;
import java.util.LinkedHashSet;
import java.util.List;
import org.testng.IAlterSuiteListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.internal.RuntimeBehavior;
import org.testng.xml.XmlSuite;

public class SmartDirtiesSuiteListener
extends SmartDirtiesTestsSupport
implements IAlterSuiteListener,
IMethodInterceptor {
    public void alter(List<XmlSuite> suites) {
        if (RuntimeBehavior.isDryRun()) {
            return;
        }
        suites.forEach(suite -> suite.getTests().forEach(xmlTest -> xmlTest.setPreserveOrder(Boolean.valueOf(false))));
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        if (RuntimeBehavior.isDryRun()) {
            return methods;
        }
        LinkedHashSet uniqueClasses = new LinkedHashSet();
        for (IMethodInstance method : methods) {
            Class<?> testClass = SmartDirtiesSuiteListener.getTestClass(method);
            uniqueClasses.add(testClass);
        }
        if (uniqueClasses.size() == 1) {
            Class<?> testClass = SmartDirtiesSuiteListener.getTestClass(methods.get(0));
            SmartDirtiesTestsSupport.setTestClassesLists("testng", TestSortResult.singletonList(testClass));
            return methods;
        }
        SmartDirtiesTestsSorter sorter = SmartDirtiesTestsSorter.getInstance();
        TestSortResult testClassesLists = sorter.sort(methods, TestClassExtractor.ofMethod(SmartDirtiesSuiteListener::getTestClass));
        SmartDirtiesTestsSupport.setTestClassesLists("testng", testClassesLists);
        return methods;
    }

    private static Class<?> getTestClass(IMethodInstance methodInstance) {
        return methodInstance.getMethod().getTestClass().getRealClass();
    }
}

