/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.JUnitPlatformSupport;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class IntegrationTestFilter {
    private static final IntegrationTestFilter instance = IntegrationTestFilter.initInstance();

    private static IntegrationTestFilter initInstance() {
        ServiceLoader<IntegrationTestFilter> serviceLoader = ServiceLoader.load(IntegrationTestFilter.class, IntegrationTestFilter.class.getClassLoader());
        Iterator<IntegrationTestFilter> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return new IntegrationTestFilter();
    }

    public static IntegrationTestFilter getInstance() {
        return instance;
    }

    protected IntegrationTestFilter() {
    }

    protected boolean isIntegrationTest(Class<?> testClass) {
        if (Modifier.isAbstract(testClass.getModifiers())) {
            return false;
        }
        if (ApplicationContextAware.class.isAssignableFrom(testClass)) {
            return true;
        }
        if (JUnitPlatformSupport.isJunit4Present() && this.isIntegrationTestJUnit4(testClass)) {
            return true;
        }
        return JUnitPlatformSupport.isJunit5JupiterApiPresent() && this.isIntegrationTestJUnit5Jupiter(testClass);
    }

    protected boolean isIntegrationTestJUnit4(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        if (runWith == null) {
            return false;
        }
        Class runner = runWith.value();
        return SpringJUnit4ClassRunner.class.isAssignableFrom(runner);
    }

    protected boolean isIntegrationTestJUnit5Jupiter(Class<?> testClass) {
        Set extendWith = AnnotatedElementUtils.findAllMergedAnnotations(testClass, ExtendWith.class);
        if (extendWith.isEmpty()) {
            return false;
        }
        return extendWith.stream().map(ExtendWith::value).flatMap(Arrays::stream).anyMatch(SpringExtension.class::isAssignableFrom);
    }
}

