/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.CurrentTestContext;
import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class SmartDirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(SmartDirtiesContextTestExecutionListener.class);
    private static final ThreadLocal<Boolean> currentAutoClosingContext = new ThreadLocal();

    public int getOrder() {
        return 2990;
    }

    public void beforeTestClass(TestContext testContext) {
        CurrentTestContext.pushCurrentTestClass(testContext.getTestClass());
        Class testClass = testContext.getTestClass();
        if (SmartDirtiesTestsSupport.isInnerClass(testClass)) {
            SmartDirtiesTestsSupport.verifyInnerClass(testClass);
        }
    }

    public void afterTestClass(TestContext testContext) {
        currentAutoClosingContext.set(true);
        try {
            Class testClass = testContext.getTestClass();
            if (SmartDirtiesTestsSupport.isLastClassPerConfig(testClass)) {
                if (testContext.hasApplicationContext()) {
                    logger.info("Auto-closing context after {}", (Object)testClass.getName());
                    testContext.markApplicationContextDirty(null);
                } else {
                    logger.info("Skipping auto-closing context after {} (already closed or failed to create)", (Object)testClass.getName());
                }
            } else {
                logger.debug("Reusing context after {}", (Object)testClass.getName());
            }
        }
        finally {
            currentAutoClosingContext.remove();
            CurrentTestContext.popCurrentTestClass();
        }
    }

    static boolean isCurrentAutoClosingContext() {
        Boolean autoClosingContext = currentAutoClosingContext.get();
        return autoClosingContext != null && autoClosingContext != false;
    }
}

