/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSorter;
import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSupport;
import com.github.seregamorph.testsmartcontext.TestClassExtractor;
import com.github.seregamorph.testsmartcontext.TestSortResult;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SmartDirtiesPostDiscoveryFilter
implements PostDiscoveryFilter {
    private static final List<String> skippedEngines = Arrays.asList("junit-jupiter", "testng");

    public FilterResult apply(TestDescriptor testDescriptor) {
        TestSortResult testSortResult;
        String engine = testDescriptor.getUniqueId().getEngineId().orElse("undefined");
        if (skippedEngines.contains(engine)) {
            return FilterResult.included((String)("Skipping engine " + engine));
        }
        List<TestDescriptor> childrenToReorder = testDescriptor.getChildren().stream().filter(childTestDescriptor -> SmartDirtiesPostDiscoveryFilter.getTestClassOrNull(childTestDescriptor) != null).collect(Collectors.toList());
        if (childrenToReorder.isEmpty()) {
            return FilterResult.included((String)"Empty list");
        }
        Set uniqueClasses = childrenToReorder.stream().map(SmartDirtiesPostDiscoveryFilter::getTestClass).collect(Collectors.toSet());
        if (uniqueClasses.size() == 1) {
            if (SmartDirtiesTestsSupport.classOrderStateMapSize(engine) <= 1) {
                Class<?> testClass = SmartDirtiesPostDiscoveryFilter.getTestClass((TestDescriptor)childrenToReorder.get(0));
                SmartDirtiesTestsSupport.setTestClassesLists(engine, TestSortResult.singletonList(testClass));
            }
            return FilterResult.included((String)"Skipping single element");
        }
        childrenToReorder.forEach(arg_0 -> ((TestDescriptor)testDescriptor).removeChild(arg_0));
        SmartDirtiesTestsSorter sorter = SmartDirtiesTestsSorter.getInstance();
        try {
            testSortResult = sorter.sort(childrenToReorder, TestClassExtractor.ofClass(SmartDirtiesPostDiscoveryFilter::getTestClass));
        }
        catch (Throwable e) {
            SmartDirtiesTestsSupport.setFailureCause(e);
            throw e;
        }
        childrenToReorder.forEach(arg_0 -> ((TestDescriptor)testDescriptor).addChild(arg_0));
        SmartDirtiesTestsSupport.setTestClassesLists(engine, testSortResult);
        return FilterResult.included((String)"sorted");
    }

    @NonNull
    private static Class<?> getTestClass(TestDescriptor testDescriptor) {
        Class<?> testClass = SmartDirtiesPostDiscoveryFilter.getTestClassOrNull(testDescriptor);
        if (testClass == null) {
            throw new UnsupportedOperationException("Unsupported TestDescriptor type " + testDescriptor.getClass() + ", failed to obtain test class");
        }
        return testClass;
    }

    @Nullable
    private static Class<?> getTestClassOrNull(TestDescriptor testDescriptor) {
        TestSource testSource = testDescriptor.getSource().orElse(null);
        if (testSource instanceof ClassSource) {
            ClassSource classSource = (ClassSource)testSource;
            return classSource.getJavaClass();
        }
        return null;
    }
}

