/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.IntegrationTestFilter;
import com.github.seregamorph.testsmartcontext.JUnitPlatformSupport;
import com.github.seregamorph.testsmartcontext.TestSortResult;
import com.github.seregamorph.testsmartcontext.jupiter.SmartDirtiesClassOrderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.context.BootstrapUtilsHelper;
import org.springframework.test.context.MergedContextConfiguration;

public class SmartDirtiesTestsSupport {
    private static final Logger log = LoggerFactory.getLogger(SmartDirtiesTestsSupport.class);
    protected static final String ENGINE_TESTNG = "testng";
    protected static final String ENGINE_JUNIT_JUPITER = "junit-jupiter";
    private static Map<String, Map<Class<?>, ClassOrderState>> engineClassOrderStateMap;
    @Nullable
    private static Throwable failureCause;

    @Nullable
    static Set<Class<?>> getTestClasses(String engine) {
        Map<Class<?>, ClassOrderState> classOrderStateMap = engineClassOrderStateMap == null ? null : engineClassOrderStateMap.get(engine);
        return classOrderStateMap == null ? null : classOrderStateMap.keySet();
    }

    protected static int classOrderStateMapSize(String engine) {
        Set<Class<?>> testClasses = SmartDirtiesTestsSupport.getTestClasses(engine);
        return testClasses == null ? 0 : testClasses.size();
    }

    static boolean isFirstClassPerConfig(Class<?> testClass) {
        if (SmartDirtiesTestsSupport.isInnerClass(testClass)) {
            return false;
        }
        List<ClassOrderState> classOrderStates = SmartDirtiesTestsSupport.getOrderStates(testClass);
        if (classOrderStates.size() == 1) {
            ClassOrderState classOrderState = classOrderStates.get(0);
            if (!classOrderState.isIntegrationTest) {
                throw new IllegalStateException("Test " + testClass + " is not recognized as integration test");
            }
            return classOrderState.isFirst;
        }
        throw new IllegalStateException("Unexpected more than one matching test engine for " + testClass);
    }

    static boolean isLastClassPerConfig(Class<?> testClass) {
        if (SmartDirtiesTestsSupport.isInnerClass(testClass)) {
            return false;
        }
        List<ClassOrderState> classOrderStates = SmartDirtiesTestsSupport.getOrderStates(testClass);
        for (ClassOrderState classOrderState : classOrderStates) {
            if (classOrderState.isIntegrationTest) continue;
            log.warn("Test {} in suite of {} engine was not recognized as spring integration test by {}, it's recommended to override the IntegrationTestFilter accordingly", new Object[]{testClass, classOrderState.testEngine, IntegrationTestFilter.getInstance().getClass()});
        }
        if (classOrderStates.isEmpty()) {
            List classes = engineClassOrderStateMap.entrySet().stream().map(entry -> {
                String engineClassNames = ((Map)entry.getValue()).keySet().stream().map(Class::getName).collect(Collectors.joining(", "));
                return (String)entry.getKey() + ": " + engineClassNames;
            }).collect(Collectors.toList());
            throw new IllegalStateException("engineClassOrderStateMap is not defined for " + testClass + ", it means that it was skipped on initial analysis or failed. Discovered classes by engine: " + classes + (failureCause == null ? "" : ": " + failureCause), failureCause);
        }
        if (classOrderStates.size() == 1) {
            return classOrderStates.get(0).isLast;
        }
        Set isLasts = classOrderStates.stream().map(state -> ((ClassOrderState)state).isLast).collect(Collectors.toSet());
        if (isLasts.size() == 1) {
            return (Boolean)isLasts.iterator().next();
        }
        assert (isLasts.size() == 2);
        log.warn("Test {} was discovered by more than one test engine with different ordering {}", testClass, classOrderStates.stream().map(state -> ((ClassOrderState)state).testEngine).collect(Collectors.toList()));
        return true;
    }

    private static List<ClassOrderState> getOrderStates(Class<?> testClass) {
        if (engineClassOrderStateMap == null) {
            if (failureCause != null) {
                throw new IllegalStateException("Test ordering is not initialized or failed", failureCause);
            }
            if (JUnitPlatformSupport.isJunit5JupiterApiPresent()) {
                try {
                    ClassLoader classLoader = SmartDirtiesTestsSupport.class.getClassLoader();
                    ArrayList<URL> junitPlatformConfigUrls = Collections.list(classLoader.getResources("junit-platform.properties"));
                    for (URL junitPlatformConfigUrl : junitPlatformConfigUrls) {
                        Properties properties = new Properties();
                        try (InputStream in = junitPlatformConfigUrl.openStream();){
                            properties.load(in);
                        }
                        String configClassOrderer = properties.getProperty("junit.jupiter.testclass.order.default");
                        if (SmartDirtiesClassOrderer.class.getName().equals(configClassOrderer)) continue;
                        throw new IllegalStateException("engineClassOrderStateMap is not initialized, because more than one junit-platform.properties was found in the classpath: " + junitPlatformConfigUrls + ". JUnit 5 supports only one configuration file https://github.com/junit-team/junit5/issues/2794\nThe " + junitPlatformConfigUrl + " " + (configClassOrderer == null ? "does not declare the junit.jupiter.testclass.order.default property" : "declares\njunit.jupiter.testclass.order.default=" + configClassOrderer + "\n") + " (should have value " + SmartDirtiesClassOrderer.class.getName() + " to address the issue)", failureCause);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (JUnitPlatformSupport.isJunit4Present() && JUnitPlatformSupport.isJUnit4IdeaTestRunnerPresent()) {
                System.err.println("The test is started via IDEA old JUnit 4 runner (not vintage), the Smart DirtiesContext behaviour is disabled.");
                if (!JUnitPlatformSupport.isJunit5JupiterApiPresent()) {
                    System.err.println("If you add org.junit.jupiter:junit-jupiter-api test dependency, \nit will allow to run packages/modules with tests with Smart DirtiesContext semantics via IDEA. See \nhttps://youtrack.jetbrains.com/issue/IDEA-343605/junit-vintage-engine-is-not-preferred-by-default\nfor details.");
                }
                return Collections.emptyList();
            }
            throw new IllegalStateException("Test ordering is not initialized or failed");
        }
        ArrayList<ClassOrderState> classOrderStates = new ArrayList<ClassOrderState>();
        for (Map<Class<?>, ClassOrderState> classOrderStateMap : engineClassOrderStateMap.values()) {
            ClassOrderState classOrderState = classOrderStateMap.get(testClass);
            if (classOrderState == null) continue;
            classOrderStates.add(classOrderState);
        }
        return classOrderStates;
    }

    protected static void setTestClassesLists(String engine, TestSortResult testSortResult) {
        LinkedHashMap<Class, ClassOrderState> classOrderStateMap = new LinkedHashMap<Class, ClassOrderState>();
        for (List<Class<?>> list : testSortResult.getSortedConfigToTests()) {
            Iterator<Class<?>> iterator = list.iterator();
            boolean isFirst = true;
            while (iterator.hasNext()) {
                Class<?> testClass = iterator.next();
                classOrderStateMap.put(testClass, new ClassOrderState(true, engine, isFirst, !iterator.hasNext()));
                isFirst = false;
            }
        }
        for (Class clazz : testSortResult.getNonItClasses()) {
            ClassOrderState prev = classOrderStateMap.put(clazz, new ClassOrderState(false, engine, false, false));
            assert (prev == null);
        }
        if (engineClassOrderStateMap == null) {
            engineClassOrderStateMap = new LinkedHashMap();
        }
        engineClassOrderStateMap.put(engine, classOrderStateMap);
    }

    protected static void setFailureCause(Throwable failureCause) {
        SmartDirtiesTestsSupport.failureCause = failureCause;
    }

    protected static void verifyInnerClass(Class<?> innerTestClass) {
        MergedContextConfiguration innerContextConfiguration;
        Class<?> enclosingClass = SmartDirtiesTestsSupport.getEnclosingClass(innerTestClass);
        MergedContextConfiguration enclosingContextConfiguration = BootstrapUtilsHelper.resolveTestContextBootstrapper(enclosingClass).buildMergedContextConfiguration();
        if (!enclosingContextConfiguration.equals((Object)(innerContextConfiguration = BootstrapUtilsHelper.resolveTestContextBootstrapper(innerTestClass).buildMergedContextConfiguration()))) {
            throw new IllegalStateException("Nested inner " + innerTestClass + " declares custom context configuration which differs from enclosing " + enclosingClass + ". This is not properly supported by the spring-test-smart-context ordering because of framework limitations. Please extract inner test class to upper level.");
        }
    }

    protected static boolean isInnerClass(Class<?> clazz) {
        return !SmartDirtiesTestsSupport.isStatic(clazz) && clazz.isMemberClass();
    }

    private static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    private static Class<?> getEnclosingClass(Class<?> clazz) {
        Class<?> enclosingClass = clazz.getEnclosingClass();
        return enclosingClass == null ? clazz : SmartDirtiesTestsSupport.getEnclosingClass(enclosingClass);
    }

    static Map<String, Map<Class<?>, ClassOrderState>> setEngineClassOrderStateMap(Map<String, Map<Class<?>, ClassOrderState>> engineClassOrderStateMap) {
        Map<String, Map<Class<?>, ClassOrderState>> prev = SmartDirtiesTestsSupport.engineClassOrderStateMap;
        SmartDirtiesTestsSupport.engineClassOrderStateMap = engineClassOrderStateMap;
        return prev;
    }

    static class ClassOrderState {
        private final boolean isIntegrationTest;
        private final String testEngine;
        private final boolean isFirst;
        private final boolean isLast;

        private ClassOrderState(boolean isIntegrationTest, String testEngine, boolean isFirst, boolean isLast) {
            this.isIntegrationTest = isIntegrationTest;
            this.testEngine = testEngine;
            this.isFirst = isFirst;
            this.isLast = isLast;
        }
    }
}

