/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext;

import com.github.seregamorph.testsmartcontext.CurrentTestContext;
import com.github.seregamorph.testsmartcontext.SmartDirtiesContextTestExecutionListener;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringContextEventLoggerListener
implements ApplicationListener<ApplicationContextEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextEventLoggerListener.class);
    private final long createdNanos = System.nanoTime();

    public SpringContextEventLoggerListener() {
        this.onCreated();
    }

    protected void onCreated() {
        String currentTestClassName = CurrentTestContext.getCurrentTestClassName();
        if (currentTestClassName == null) {
            logger.warn("Could not resolve current class name, ensure that SmartDirtiesContextTestExecutionListener is registered for test class. Hint:\nMaybe you should set @TestExecutionListeners.mergeMode to MERGE_WITH_DEFAULTS for your test class.");
        } else {
            logger.info("Creating context for {}", (Object)currentTestClassName);
        }
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        }
    }

    protected void onContextRefreshedEvent(ContextRefreshedEvent event) {
        long nowNanos = System.nanoTime();
        String contextInitFormatted = SpringContextEventLoggerListener.formatNanos(nowNanos - this.createdNanos);
        boolean isChild = event.getApplicationContext().getParent() != null;
        logger.info("Created {} in {} for {}", new Object[]{isChild ? "child context" : "context", contextInitFormatted, CurrentTestContext.getCurrentTestClassName()});
    }

    protected void onContextClosedEvent(ContextClosedEvent event) {
        boolean isChild;
        String testClassIdentifier = CurrentTestContext.getCurrentTestClassName();
        boolean bl = isChild = event.getApplicationContext().getParent() != null;
        if (testClassIdentifier == null) {
            logger.info("Destroying {}", (Object)(isChild ? "child context" : "context"));
        } else {
            logger.info("Destroying {} for {}", (Object)(isChild ? "child context" : "context"), (Object)testClassIdentifier);
        }
    }

    protected boolean isCurrentAutoClosingContext() {
        return SmartDirtiesContextTestExecutionListener.isCurrentAutoClosingContext();
    }

    static String formatNanos(long timeNanos) {
        long millis = TimeUnit.NANOSECONDS.toMillis(timeNanos);
        return String.format(Locale.ROOT, "%.3f", (double)millis / 1000.0) + "s";
    }
}

