/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext.jdbc;

import com.github.seregamorph.testsmartcontext.jdbc.CloseableDelegatingDataSource;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.function.SingletonSupplier;

public class LateInitDataSource
extends CloseableDelegatingDataSource {
    @Nullable
    private final String name;
    private final Supplier<DataSource> dataSourceSupplier;

    public LateInitDataSource(Supplier<DataSource> dataSourceSupplier) {
        this(null, dataSourceSupplier);
    }

    public LateInitDataSource(String name, Supplier<DataSource> dataSourceSupplier) {
        this.name = name;
        this.dataSourceSupplier = SingletonSupplier.of(() -> {
            DataSource dataSource = (DataSource)dataSourceSupplier.get();
            this.setTargetDataSource(dataSource);
            return dataSource;
        });
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void afterPropertiesSet() {
    }

    protected DataSource obtainTargetDataSource() {
        return this.dataSourceSupplier.get();
    }

    public String toString() {
        return "LateInitDataSource{" + (this.name == null ? "" : "name='" + this.name + '\'') + ", delegate=" + this.getTargetDataSource() + '}';
    }
}

