/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.testsmartcontext.jupiter;

import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSorter;
import com.github.seregamorph.testsmartcontext.SmartDirtiesTestsSupport;
import com.github.seregamorph.testsmartcontext.TestClassExtractor;
import com.github.seregamorph.testsmartcontext.TestSortResult;
import java.lang.reflect.AnnotatedElement;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Nested;
import org.springframework.core.annotation.AnnotationUtils;

public class SmartDirtiesClassOrderer
extends SmartDirtiesTestsSupport
implements ClassOrderer {
    public void orderClasses(ClassOrdererContext context) {
        TestSortResult testClassesLists;
        List classDescriptors = context.getClassDescriptors();
        if (classDescriptors.isEmpty()) {
            return;
        }
        LinkedHashSet<Class> uniqueClasses = new LinkedHashSet<Class>();
        for (ClassDescriptor classDescriptor : classDescriptors) {
            Class testClass = classDescriptor.getTestClass();
            if (SmartDirtiesClassOrderer.isInnerClass(testClass)) {
                if (!uniqueClasses.isEmpty()) {
                    throw new IllegalStateException("Unexpected mix of inner " + testClass + " and " + uniqueClasses);
                }
                Nested nested = (Nested)AnnotationUtils.getAnnotation((AnnotatedElement)testClass, Nested.class);
                if (nested == null) {
                    throw new IllegalStateException("Missing @Nested annotation for inner " + testClass);
                }
                SmartDirtiesClassOrderer.verifyInnerClass(testClass);
                continue;
            }
            uniqueClasses.add(testClass);
        }
        if (uniqueClasses.isEmpty()) {
            if (SmartDirtiesTestsSupport.classOrderStateMapSize("junit-jupiter") == 0) {
                throw new IllegalStateException("orderClasses is called with inner classes list " + classDescriptors + " before being called with enclosing class list");
            }
            return;
        }
        if (uniqueClasses.size() == 1) {
            if (SmartDirtiesTestsSupport.classOrderStateMapSize("junit-jupiter") <= 1) {
                Class testClass = ((ClassDescriptor)classDescriptors.get(0)).getTestClass();
                SmartDirtiesTestsSupport.setTestClassesLists("junit-jupiter", TestSortResult.singletonList(testClass));
            }
            return;
        }
        SmartDirtiesTestsSorter sorter = SmartDirtiesTestsSorter.getInstance();
        try {
            testClassesLists = sorter.sort(classDescriptors, TestClassExtractor.ofClass(ClassDescriptor::getTestClass));
        }
        catch (Throwable e) {
            SmartDirtiesTestsSupport.setFailureCause(e);
            throw e;
        }
        SmartDirtiesTestsSupport.setTestClassesLists("junit-jupiter", testClassesLists);
    }
}

