/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.server.request;

import com.yuyenews.easy.server.request.HttpSession;
import com.yuyenews.easy.server.request.RequestParser;
import com.yuyenews.easy.server.request.model.FileUpLoad;
import com.yuyenews.easy.server.sessionm.SessionManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    private Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    private FullHttpRequest httpRequest;
    private ChannelHandlerContext ctx;
    private String body;
    private Map<String, Object> paremeters;
    private Map<String, FileUpLoad> files;

    public HttpRequest(FullHttpRequest httpRequest, ChannelHandlerContext ctx) {
        this.body = this.getBody(httpRequest);
        this.setParemeters(this.getPams(httpRequest));
        this.httpRequest = httpRequest;
        this.ctx = ctx;
    }

    public HttpMethod getMethod() {
        return this.httpRequest.method();
    }

    public String getUri() {
        return this.httpRequest.uri();
    }

    public Object getHeader(String key) {
        return this.httpRequest.headers().get((Object)key);
    }

    public HttpHeaders getHeaders() {
        return this.httpRequest.headers();
    }

    public Map<String, Object> getParemeters() {
        return this.paremeters;
    }

    private void setParemeters(Map<String, Object> paremeters) {
        Object obj = paremeters.get("files");
        if (obj != null) {
            Map files;
            this.files = files = (Map)obj;
            paremeters.remove("files");
        }
        this.paremeters = paremeters;
    }

    public Object getParemeter(String key) {
        Object objs = this.paremeters.get(key);
        if (objs != null) {
            List lis = (List)objs;
            return lis.get(0);
        }
        return null;
    }

    public List<Object> getParemeterValues(String key) {
        Object objs = this.paremeters.get(key);
        if (objs != null) {
            List lis = (List)objs;
            return lis;
        }
        return null;
    }

    public Map<String, FileUpLoad> getFiles() {
        return this.files;
    }

    public FileUpLoad getFile(String name) {
        if (this.files != null && this.files.size() > 0) {
            return this.files.get(name);
        }
        return null;
    }

    public String getUrl() {
        return this.httpRequest.uri();
    }

    public String getBody() {
        return this.body;
    }

    public FullHttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    private String getBody(FullHttpRequest request) {
        ByteBuf buf = request.content();
        return buf.toString(CharsetUtil.UTF_8);
    }

    private Map<String, Object> getPams(FullHttpRequest request) {
        try {
            return new RequestParser(request).parse();
        }
        catch (IOException e) {
            this.logger.error("\u4ece\u8bf7\u6c42\u4e2d\u83b7\u53d6\u53c2\u6570\uff0c\u62a5\u9519", (Throwable)e);
            return new Hashtable<String, Object>();
        }
    }

    public HttpSession getHttpSession() {
        return SessionManager.getHttpSession(this);
    }

    public String getIp() {
        String clientIP = String.valueOf(this.httpRequest.headers().get((Object)"X-Forwarded-For"));
        if (clientIP == null || clientIP.equals("null")) {
            InetSocketAddress insocket = (InetSocketAddress)this.ctx.channel().remoteAddress();
            clientIP = insocket.getAddress().getHostAddress();
        }
        return clientIP;
    }
}

