/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.server.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yuyenews.easy.server.constant.EasySpace;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponse {
    private Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private ChannelHandlerContext ctx;
    private Map<String, String> header;

    public HttpResponse(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.header = new HashMap<String, String>();
    }

    public void setHeader(String key, String value) {
        this.header.put(key, value);
    }

    public void send(String context) {
        this.send(context, HttpResponseStatus.OK);
    }

    public void send(String context, HttpResponseStatus status) {
        Object contentType;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)context, (Charset)CharsetUtil.UTF_8));
        this.crossDomain((FullHttpResponse)response);
        if (this.header != null) {
            for (String key : this.header.keySet()) {
                response.headers().set((CharSequence)key, (CharSequence)this.header.get(key));
            }
        }
        if ((contentType = this.getConfig().get((Object)"content_type")) == null) {
            contentType = "text/json; charset=UTF-8";
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType.toString());
        this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Deprecated
    public void sendFile(File file) {
        this.logger.warn("sendFile\u65b9\u6cd5\u8fd8\u4e0d\u80fd\u7528\u54e6\uff0c\u6b63\u5728\u5f00\u53d1\u4e2d....");
    }

    @Deprecated
    public void sendFile(byte[] file) {
        this.logger.warn("sendFile\u65b9\u6cd5\u8fd8\u4e0d\u80fd\u7528\u54e6\uff0c\u6b63\u5728\u5f00\u53d1\u4e2d....");
    }

    @Deprecated
    public void sendFile(InputStream file) {
        this.logger.warn("sendFile\u65b9\u6cd5\u8fd8\u4e0d\u80fd\u7528\u54e6\uff0c\u6b63\u5728\u5f00\u53d1\u4e2d....");
    }

    private void crossDomain(FullHttpResponse response) {
        JSONObject jsonObject = this.getConfig();
        Object object = jsonObject.get((Object)"cross_domain");
        if (object != null) {
            JSONObject ob = JSONObject.parseObject((String)JSON.toJSONString((Object)object));
            response.headers().set((CharSequence)"Access-Control-Allow-Origin", (CharSequence)ob.get((Object)"origin").toString());
            response.headers().set((CharSequence)"Access-Control-Allow-Methods", (CharSequence)ob.get((Object)"methods").toString());
            response.headers().set((CharSequence)"Access-Control-Max-Age", (CharSequence)ob.get((Object)"maxAge").toString());
            response.headers().set((CharSequence)"Access-Control-Allow-Headers", (CharSequence)"x-requested-with,Cache-Control,Pragma,Content-Type,Token");
            response.headers().set((CharSequence)"Access-Control-Allow-Credentials", (CharSequence)"true");
        }
    }

    private JSONObject getConfig() {
        EasySpace constants = EasySpace.getEasySpace();
        Object obj = constants.getAttr("config");
        if (obj != null) {
            JSONObject jsonObject = (JSONObject)obj;
            return jsonObject;
        }
        return new JSONObject();
    }
}

