/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.server.request;

import com.yuyenews.easy.server.request.model.FileUpLoad;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RequestParser {
    private FullHttpRequest fullReq;

    public RequestParser(FullHttpRequest req) {
        this.fullReq = req;
    }

    public Map<String, Object> parse() throws IOException {
        HttpMethod method = this.fullReq.method();
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        if (HttpMethod.GET == method) {
            QueryStringDecoder decoder = new QueryStringDecoder(this.fullReq.uri());
            decoder.parameters().entrySet().forEach(entry -> parmMap.put((String)entry.getKey(), entry.getValue()));
        } else if (HttpMethod.POST == method) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)this.fullReq);
            decoder.offer((HttpContent)this.fullReq);
            List parmList = decoder.getBodyHttpDatas();
            Hashtable<String, FileUpLoad> files = new Hashtable<String, FileUpLoad>();
            for (InterfaceHttpData parm : parmList) {
                if (parm instanceof Attribute) {
                    Attribute data = (Attribute)parm;
                    ArrayList<String> ps = null;
                    Object objs = parmMap.get(data.getName());
                    ps = objs == null ? new ArrayList<String>() : (ArrayList<String>)objs;
                    ps.add(data.getValue());
                    parmMap.put(data.getName(), ps);
                    continue;
                }
                if (!(parm instanceof MixedFileUpload)) continue;
                MixedFileUpload fileUpload = (MixedFileUpload)parm;
                byte[] bs = fileUpload.get();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bs);
                FileUpLoad upLoad = new FileUpLoad();
                upLoad.setFileName(fileUpload.getFilename());
                upLoad.setInputStream(inputStream);
                upLoad.setName(fileUpload.getName());
                files.put(fileUpload.getName(), upLoad);
            }
            parmMap.put("files", files);
        }
        return parmMap;
    }
}

