/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.server.sessionm;

import com.alibaba.fastjson.JSONObject;
import com.yuyenews.easy.server.constant.EasySpace;
import com.yuyenews.easy.server.request.HttpContext;
import com.yuyenews.easy.server.request.HttpRequest;
import com.yuyenews.easy.server.request.HttpSession;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class SessionManager {
    private static HttpContext context = HttpContext.getHttpContext();

    public static String getSessionId(HttpRequest request) {
        Object obj = request.getHeaders().get((Object)"sessionId");
        if (obj == null && (obj = request.getParemeter("sessionId")) == null) {
            return null;
        }
        return obj.toString();
    }

    public static HttpSession getHttpSession(HttpRequest request) {
        String sessionId = SessionManager.getSessionId(request);
        if (sessionId == null) {
            return null;
        }
        Map<String, HttpSession> sessions = SessionManager.getSessionList();
        HttpSession httpSession = sessions.get(sessionId);
        if (httpSession != null && SessionManager.hasShiXiao(httpSession)) {
            sessions.remove(sessionId);
            httpSession = null;
        }
        if (httpSession == null) {
            httpSession = new HttpSession();
            sessions.put(sessionId, httpSession);
            context.setAttr("session", sessions);
        }
        return httpSession;
    }

    public static Map<String, HttpSession> getSessionList() {
        Map<String, HttpSession> sessions = new Hashtable<String, HttpSession>();
        Object sessionList = context.getAttr("session");
        if (sessionList != null) {
            sessions = (Map)sessionList;
        }
        return sessions;
    }

    private static boolean hasShiXiao(HttpSession httpSession) {
        long cha;
        long mil = httpSession.getDate().getTime();
        long nmil = new Date().getTime();
        JSONObject jsonObject = SessionManager.getConfig();
        Object sessionTimeo = jsonObject.get((Object)"sessionTime");
        Long sessionTime = 3600000L;
        if (sessionTimeo != null) {
            sessionTime = Long.parseLong(sessionTimeo.toString());
        }
        return (cha = nmil - mil) > sessionTime;
    }

    private static JSONObject getConfig() {
        EasySpace constants = EasySpace.getEasySpace();
        Object obj = constants.getAttr("config");
        if (obj != null) {
            JSONObject jsonObject = (JSONObject)obj;
            return jsonObject;
        }
        return new JSONObject();
    }
}

