/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.stl.FlatLoessInterpolator;
import com.github.servicenow.ds.stats.stl.LinearLoessInterpolator;
import com.github.servicenow.ds.stats.stl.QuadraticLoessInterpolator;

abstract class LoessInterpolator {
    private final int fWidth;
    private final double[] fExternalWeights;
    final double[] fData;
    final double[] fWeights;

    Double smoothOnePoint(double x, int left, int right) {
        State state = this.computeNeighborhoodWeights(x, left, right);
        if (state == State.WEIGHTS_FAILED) {
            return null;
        }
        if (state == State.LINEAR_OK) {
            this.updateWeights(x, left, right);
        }
        double ys = 0.0;
        for (int i = left; i <= right; ++i) {
            ys += this.fWeights[i] * this.fData[i];
        }
        return ys;
    }

    abstract void updateWeights(double var1, int var3, int var4);

    private State computeNeighborhoodWeights(double x, int left, int right) {
        int j;
        double lambda = Math.max(x - (double)left, (double)right - x);
        if (this.fWidth > this.fData.length) {
            lambda += (double)((this.fWidth - this.fData.length) / 2);
        }
        double l999 = 0.999 * lambda;
        double l001 = 0.001 * lambda;
        double totalWeight = 0.0;
        for (j = left; j <= right; ++j) {
            double delta = Math.abs(x - (double)j);
            double weight = 0.0;
            if (delta <= l999) {
                if (delta <= l001) {
                    weight = 1.0;
                } else {
                    double fraction = delta / lambda;
                    double trix = 1.0 - fraction * fraction * fraction;
                    weight = trix * trix * trix;
                }
                if (this.fExternalWeights != null) {
                    weight *= this.fExternalWeights[j];
                }
                totalWeight += weight;
            }
            this.fWeights[j] = weight;
        }
        if (totalWeight <= 0.0) {
            return State.WEIGHTS_FAILED;
        }
        j = left;
        while (j <= right) {
            int n = j++;
            this.fWeights[n] = this.fWeights[n] / totalWeight;
        }
        return lambda > 0.0 ? State.LINEAR_OK : State.LINEAR_FAILED;
    }

    LoessInterpolator(int width, double[] data, double[] externalWeights) {
        this.fWidth = width;
        this.fData = data;
        this.fExternalWeights = externalWeights;
        this.fWeights = new double[data.length];
    }

    private static enum State {
        WEIGHTS_FAILED,
        LINEAR_FAILED,
        LINEAR_OK;

    }

    static class Builder {
        private Integer fWidth = null;
        private int fDegree = 1;
        private double[] fExternalWeights = null;

        Builder() {
        }

        public Builder setWidth(int width) {
            this.fWidth = width;
            return this;
        }

        Builder setDegree(int degree) {
            if (degree < 0 || degree > 2) {
                throw new IllegalArgumentException("Degree must be 0, 1 or 2");
            }
            this.fDegree = degree;
            return this;
        }

        Builder setExternalWeights(double[] weights) {
            this.fExternalWeights = weights;
            return this;
        }

        LoessInterpolator interpolate(double[] data) {
            if (this.fWidth == null) {
                throw new IllegalStateException("LoessInterpolator.Builder: Width must be set");
            }
            if (data == null) {
                throw new IllegalStateException("LoessInterpolator.Builder: data must be non-null");
            }
            switch (this.fDegree) {
                case 0: {
                    return new FlatLoessInterpolator(this.fWidth, data, this.fExternalWeights);
                }
                case 1: {
                    return new LinearLoessInterpolator(this.fWidth, data, this.fExternalWeights);
                }
                case 2: {
                    return new QuadraticLoessInterpolator(this.fWidth, data, this.fExternalWeights);
                }
            }
            return null;
        }
    }
}

