/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.stl.LoessInterpolator;

class QuadraticLoessInterpolator
extends LoessInterpolator {
    QuadraticLoessInterpolator(int width, double[] data, double[] externalWeights) {
        super(width, data, externalWeights);
    }

    @Override
    protected final void updateWeights(double x, int left, int right) {
        double x1Mean = 0.0;
        double x2Mean = 0.0;
        double x3Mean = 0.0;
        double x4Mean = 0.0;
        for (int i = left; i <= right; ++i) {
            double w = this.fWeights[i];
            double x1w = (double)i * w;
            double x2w = (double)i * x1w;
            double x3w = (double)i * x2w;
            double x4w = (double)i * x3w;
            x1Mean += x1w;
            x2Mean += x2w;
            x3Mean += x3w;
            x4Mean += x4w;
        }
        double m2 = x2Mean - x1Mean * x1Mean;
        double m4 = x4Mean - x2Mean * x2Mean;
        double m3 = x3Mean - x2Mean * x1Mean;
        double denominator = m2 * m4 - m3 * m3;
        double range = this.fData.length - 1;
        if (denominator > 1.0E-6 * range * range) {
            double beta2 = m4 / denominator;
            double beta3 = m3 / denominator;
            double beta4 = m2 / denominator;
            double x1 = x - x1Mean;
            double x2 = x * x - x2Mean;
            double a1 = beta2 * x1 - beta3 * x2;
            double a2 = beta4 * x2 - beta3 * x1;
            for (int i = left; i <= right; ++i) {
                int n = i;
                this.fWeights[n] = this.fWeights[n] * (1.0 + a1 * ((double)i - x1Mean) + a2 * ((double)(i * i) - x2Mean));
            }
        }
    }
}

