/*
 * Decompiled with CFR 0.152.
 */
package org.sevntu.maven.plugin.dsm;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dtangler.core.analysis.configurableanalyzer.ConfigurableDependencyAnalyzer;
import org.dtangler.core.analysisresult.AnalysisResult;
import org.dtangler.core.configuration.Arguments;
import org.dtangler.core.dependencies.Dependable;
import org.dtangler.core.dependencies.Dependencies;
import org.dtangler.core.dependencies.DependencyGraph;
import org.dtangler.core.dependencies.Scope;
import org.dtangler.core.dependencyengine.DependencyEngine;
import org.dtangler.core.dependencyengine.DependencyEngineFactory;
import org.dtangler.core.dsm.Dsm;
import org.dtangler.core.dsm.DsmRow;
import org.dtangler.core.dsmengine.DsmEngine;
import org.sevntu.maven.plugin.dsm.DsmHtmlWriter;

public class DsmReportEngine {
    private DsmHtmlWriter dsmHtmlWriter;
    private String outputDirectory;
    private String sourceDirectory;
    private boolean obfuscatePackageNames;

    public void setSourceDirectory(String aSourceDirectory) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)aSourceDirectory)) {
            throw new IllegalArgumentException("Source directory path can't be empty.");
        }
        if (!new File(aSourceDirectory).exists()) {
            throw new IllegalArgumentException("Source directory '" + aSourceDirectory + "' not exists");
        }
        this.sourceDirectory = aSourceDirectory;
    }

    public void setOutputDirectory(String aOutputDirectory) {
        if (Strings.isNullOrEmpty((String)aOutputDirectory)) {
            throw new IllegalArgumentException("Dsm directory is empty.");
        }
        this.outputDirectory = aOutputDirectory + File.separator;
    }

    public void setObfuscatePackageNames(boolean obfuscate) {
        this.obfuscatePackageNames = obfuscate;
    }

    private static List<String> getPackageNames(Dsm aDsm) {
        List dsmRowList = aDsm.getRows();
        ArrayList<String> packageNames = new ArrayList<String>();
        for (DsmRow dsmRow : dsmRowList) {
            packageNames.add(dsmRow.getDependee().toString());
        }
        return packageNames;
    }

    private static Set<Dependable> getDependablesByRowIndex(Dsm aDsm, int aRow) {
        HashSet<Dependable> result = new HashSet<Dependable>();
        result.add(((DsmRow)aDsm.getRows().get(aRow)).getDependee());
        return result;
    }

    private static AnalysisResult getAnalysisResult(Arguments aArguments, Dependencies aDependencies) {
        return new ConfigurableDependencyAnalyzer(aArguments).analyze(aDependencies);
    }

    public void report() throws Exception {
        this.dsmHtmlWriter = new DsmHtmlWriter(this.outputDirectory, this.obfuscatePackageNames);
        ArrayList<String> sourcePathList = new ArrayList<String>();
        sourcePathList.add(this.sourceDirectory);
        this.report(sourcePathList);
    }

    private void report(List<String> aSourcePathList) throws Exception {
        Arguments arguments = new Arguments();
        arguments.setInput(aSourcePathList);
        DependencyEngine engine = new DependencyEngineFactory().getDependencyEngine(arguments);
        Dependencies dependencies = engine.getDependencies(arguments);
        DependencyGraph dependencyGraph = dependencies.getDependencyGraph();
        AnalysisResult analysisResult = DsmReportEngine.getAnalysisResult(arguments, dependencies);
        Dsm dsm = new DsmEngine(dependencyGraph).createDsm();
        this.printDsmNavigation(dsm);
        this.printDsmForPackages(dsm, analysisResult);
        this.printDsmForClasses(dsm, dependencies, analysisResult, DsmReportEngine.getPackageNames(dsm));
        this.copySiteSource();
    }

    private void copySiteSource() throws Exception {
        DsmReportEngine.copyFileToSiteFolder(this.outputDirectory, "", "index.html");
        DsmReportEngine.copyFileToSiteFolder(this.outputDirectory, "css", "style.css");
        DsmReportEngine.copyFileToSiteFolder(this.outputDirectory, "images", "class.png");
        DsmReportEngine.copyFileToSiteFolder(this.outputDirectory, "images", "package.png");
        DsmReportEngine.copyFileToSiteFolder(this.outputDirectory, "images", "packages.png");
    }

    private void printDsmForPackages(Dsm aDsm, AnalysisResult aAnalysisResult) throws Exception {
        if (this.obfuscatePackageNames) {
            this.dsmHtmlWriter.printDsm(aDsm, aAnalysisResult, "all_packages", "packages_page_truncated.ftl");
        } else {
            this.dsmHtmlWriter.printDsm(aDsm, aAnalysisResult, "all_packages", "packages_page.ftl");
        }
    }

    private void printDsmNavigation(Dsm aDsm) throws Exception {
        List<String> packageNames = DsmReportEngine.getPackageNames(aDsm);
        this.dsmHtmlWriter.printDsmPackagesNavigation(packageNames);
    }

    private void printDsmForClasses(Dsm aDsm, Dependencies aDependencies, AnalysisResult aAnalysisResult, List<String> aPackageNames) throws Exception {
        Scope scope = aDependencies.getChildScope(aDependencies.getDefaultScope());
        for (int packageIndex = 0; packageIndex < aDsm.getRows().size(); ++packageIndex) {
            Set<Dependable> dependableSet = DsmReportEngine.getDependablesByRowIndex(aDsm, packageIndex);
            DependencyGraph dependencyGraph = aDependencies.getDependencyGraph(scope, dependableSet, Dependencies.DependencyFilter.none);
            Dsm dsm = new DsmEngine(dependencyGraph).createDsm();
            this.dsmHtmlWriter.printDsm(dsm, aAnalysisResult, aPackageNames.get(packageIndex), "classes_page.ftl");
        }
    }

    private static void copyFileToSiteFolder(String aSiteDirectory, String aDirName, String aFileName) throws Exception {
        String fileName;
        if (aDirName != null && !aDirName.isEmpty()) {
            new File(aSiteDirectory + aDirName).mkdirs();
            fileName = aDirName + "/" + aFileName;
        } else {
            fileName = aFileName;
        }
        DsmReportEngine.copyFileToSiteFolder(aSiteDirectory, fileName);
    }

    private static void copyFileToSiteFolder(String aSiteDirectory, String aFileName) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int numberOfBytes;
            inputStream = DsmReportEngine.class.getResourceAsStream("/" + aFileName);
            outputStream = new FileOutputStream(new File(aSiteDirectory + aFileName));
            byte[] buffer = new byte[1024];
            while ((numberOfBytes = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, numberOfBytes);
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                throw new RuntimeException("Can't find " + aSiteDirectory + aFileName + " file. " + e.getMessage(), e);
            }
            throw new RuntimeException("Unable to copy source file. " + e.getMessage(), e);
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }
}

