/*
 * Decompiled with CFR 0.152.
 */
package org.sevntu.maven.plugin.dsm;

import com.google.common.base.Strings;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hjug.dtangler.core.analysisresult.AnalysisResult;
import org.hjug.dtangler.core.analysisresult.Violation;
import org.hjug.dtangler.core.dsm.Dsm;
import org.hjug.dtangler.core.dsm.DsmCell;
import org.hjug.dtangler.core.dsm.DsmRow;
import org.sevntu.maven.plugin.dsm.DsmRowModel;

public class DsmHtmlWriter {
    public static final String FILE_FORMAT = ".html";
    public static final String IMAGE_FOLDER_NAME = "images";
    public static final String CSS_FOLDER_NAME = "css";
    public static final String FTL_CLASSES_PAGE = "classes_page.ftl";
    public static final String FTL_PACKAGES_PAGE = "packages_page.ftl";
    public static final String FTL_PACKAGES_PAGE_TRUNC = "packages_page_truncated.ftl";
    public static final String FTL_PACKAGES_MENU = "packages_menu.ftl";
    private final String reportSiteDirectory;
    private final boolean obfuscatePackageNames;

    public DsmHtmlWriter(String aReportSiteDirectory, boolean obfuscate) {
        if (Strings.isNullOrEmpty((String)aReportSiteDirectory)) {
            throw new IllegalArgumentException("Path to the report directory should not be null or empty");
        }
        this.obfuscatePackageNames = obfuscate;
        this.reportSiteDirectory = aReportSiteDirectory;
        new File(this.reportSiteDirectory).mkdirs();
    }

    private static ByteArrayOutputStream renderTemplate(Map<String, Object> aDataModel, String aTemplateName) throws Exception {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(DsmHtmlWriter.class, File.separator + "templates");
        Template tpl = cfg.getTemplate(aTemplateName);
        ByteArrayOutputStream outputStrem = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStrem);
        tpl.process(aDataModel, (Writer)outputStreamWriter);
        return outputStrem;
    }

    private void writeStreamToFile(ByteArrayOutputStream byteOutputStream, String aFileName) throws Exception {
        String filePath = this.reportSiteDirectory + File.separator + aFileName + FILE_FORMAT;
        FileOutputStream outputStream = new FileOutputStream(filePath);
        ((OutputStream)outputStream).write(byteOutputStream.toByteArray());
        ((OutputStream)outputStream).close();
    }

    public void printDsmPackagesNavigation(List<String> aPackageNames) throws Exception {
        if (aPackageNames == null) {
            throw new IllegalArgumentException("List of package names should not be null");
        }
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("aPackageNames", aPackageNames);
        this.writeModelToFile("packages", FTL_PACKAGES_MENU, dataModel);
        ByteArrayOutputStream outputStream = DsmHtmlWriter.renderTemplate(dataModel, FTL_PACKAGES_MENU);
        this.writeStreamToFile(outputStream, "packages");
        outputStream.close();
    }

    public void printDsm(Dsm aDsm, AnalysisResult aAnalysisResult, String aName, String templateName) throws Exception {
        if (aDsm == null) {
            throw new IllegalArgumentException("DSM structure should not be null");
        }
        if (aAnalysisResult == null) {
            throw new IllegalArgumentException("Analysis structure should not be null");
        }
        if (Strings.isNullOrEmpty((String)aName)) {
            throw new IllegalArgumentException("Title of DSM should not be empty");
        }
        ArrayList<DsmRowModel> dsmRowsData = new ArrayList<DsmRowModel>();
        ArrayList<String> names = new ArrayList<String>();
        int[] numberOfClassesInPackage = new int[aDsm.getRows().size()];
        for (int packageIndex = 0; packageIndex < aDsm.getRows().size(); ++packageIndex) {
            DsmRow dsmRow = (DsmRow)aDsm.getRows().get(packageIndex);
            String packageName = dsmRow.getDependee().getDisplayName();
            names.add(packageName);
            numberOfClassesInPackage[packageIndex] = dsmRow.getDependee().getContentCount();
            String truncatedPackageName = this.truncatePackageName(packageName, 20);
            ArrayList<String> dependenciesNumbers = new ArrayList<String>();
            for (DsmCell dep : dsmRow.getCells()) {
                dependenciesNumbers.add(DsmHtmlWriter.formatDependency(dep, aAnalysisResult));
            }
            DsmRowModel rowData = new DsmRowModel(packageIndex + 1, packageName, truncatedPackageName, dependenciesNumbers);
            dsmRowsData.add(rowData);
        }
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("title", aName);
        dataModel.put("rows", dsmRowsData);
        dataModel.put("names", names);
        dataModel.put("numberOfClasses", numberOfClassesInPackage);
        this.writeModelToFile(aName, templateName, dataModel);
    }

    private void writeModelToFile(String aFileName, String aTemplateName, Map<String, Object> aDataModel) throws Exception {
        ByteArrayOutputStream outputStream = DsmHtmlWriter.renderTemplate(aDataModel, aTemplateName);
        this.writeStreamToFile(outputStream, aFileName);
        outputStream.close();
    }

    private static String formatDependency(DsmCell aDep, AnalysisResult aAnalysisResult) {
        String dependencyType;
        if (!aDep.isValid()) {
            dependencyType = "x";
        } else if (aDep.getDependencyWeight() == 0) {
            dependencyType = "";
        } else {
            dependencyType = Integer.toString(aDep.getDependencyWeight());
            if (!aAnalysisResult.getViolations(aDep.getDependency(), Violation.Severity.error).isEmpty()) {
                dependencyType = dependencyType + "C";
            }
        }
        return dependencyType;
    }

    private String truncatePackageName(String name, int length) {
        String truncatedName = name;
        if (this.obfuscatePackageNames) {
            String[] nameTokens = name.split("\\.");
            for (int numberOfToken = 0; numberOfToken < nameTokens.length && truncatedName.length() > length; ++numberOfToken) {
                String currentToken = nameTokens[numberOfToken];
                truncatedName = truncatedName.replace(currentToken + ".", currentToken.substring(0, 1) + ".");
            }
        } else if (name.length() - 2 > length) {
            truncatedName = ".." + name.substring(name.length() - length - 2);
        }
        return truncatedName;
    }
}

