/*
 * Decompiled with CFR 0.152.
 */
package org.sevntu.maven.plugin.dsm;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.sevntu.maven.plugin.dsm.DsmReportEngine;

public class DsmReportMojo
extends AbstractMavenReport {
    private final String dsmDirectory = "dsm";
    private File reportingOutputDirectory;
    private File outputDirectory;
    private boolean obfuscatePackageNames;
    private MavenProject project;
    private Renderer siteRenderer;

    public void setObfuscatePackageNames(boolean aObfuscate) {
        this.obfuscatePackageNames = aObfuscate;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getOutputName() {
        return "dsm" + File.separator + "index";
    }

    public String getName(Locale aLocale) {
        return this.getBundle(aLocale).getString("report.dsm-report.name");
    }

    public String getDescription(Locale aLocale) {
        return this.getBundle(aLocale).getString("report.dsm-report.description");
    }

    protected String getOutputDirectory() {
        return this.reportingOutputDirectory.getAbsolutePath() + File.separator + "dsm";
    }

    private String getSourseDir() {
        return this.outputDirectory.getAbsolutePath();
    }

    private ResourceBundle getBundle(Locale aLocale) {
        return ResourceBundle.getBundle("dsm-report", aLocale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void executeReport(Locale aLocale) throws MavenReportException {
        DsmReportEngine dsmReport = new DsmReportEngine();
        dsmReport.setObfuscatePackageNames(this.obfuscatePackageNames);
        dsmReport.setSourceDirectory(this.getSourseDir());
        dsmReport.setOutputDirectory(this.getOutputDirectory());
        try {
            dsmReport.report();
        }
        catch (Exception e) {
            throw new MavenReportException("Error in DSM Report generation.", e);
        }
    }

    public boolean isExternalReport() {
        return true;
    }
}

