/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.LinkedList;
import java.util.List;

public class AvoidNotShortCircuitOperatorsForBooleanCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.not.short.circuit.operators.for.boolean";
    private static final String BOOLEAN = "boolean";
    private final List<String> supportedOperands = new LinkedList<String>();
    private boolean hasTrueOrFalseLiteral;

    public final int[] getDefaultTokens() {
        return new int[]{112, 114, 108, 106};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public final void visitToken(DetailAST detailAST) {
        DetailAST currentNode = detailAST;
        while (currentNode != null && currentNode.getType() != 28) {
            if ((currentNode = currentNode.getParent()).getType() != 6) continue;
            currentNode = null;
        }
        if (currentNode != null && this.isBooleanExpression(currentNode)) {
            this.log(detailAST, MSG_KEY, new Object[]{detailAST.getText()});
        }
        this.supportedOperands.clear();
        this.hasTrueOrFalseLiteral = false;
    }

    private static boolean isBooleanType(DetailAST node) {
        return BOOLEAN.equals(CheckUtils.createFullType((DetailAST)node.findFirstToken(13)).getText());
    }

    public final boolean isBooleanExpression(DetailAST node) {
        DetailAST curNode = node;
        List<String> childNames = this.getSupportedOperandsNames(curNode);
        LinkedList<String> booleanVariablesNames = new LinkedList<String>();
        while (curNode.getType() != 8 && curNode.getType() != 9 && curNode.getType() != 14 && curNode.getType() != 15 && curNode.getType() != 157 && curNode.getType() != 154) {
            curNode = curNode.getParent();
        }
        int line = node.getLineNo();
        for (DetailAST currentNode : AvoidNotShortCircuitOperatorsForBooleanCheck.getChildren(curNode.getLastChild())) {
            if (currentNode.getLineNo() >= line || currentNode.getType() != 10 || !AvoidNotShortCircuitOperatorsForBooleanCheck.isBooleanType(currentNode)) continue;
            booleanVariablesNames.add(currentNode.findFirstToken(58).getText());
        }
        boolean result = false;
        for (String name : childNames) {
            if (!booleanVariablesNames.contains(name)) continue;
            result = true;
            break;
        }
        result = result || this.hasTrueOrFalseLiteral(node);
        return result;
    }

    public final List<String> getSupportedOperandsNames(DetailAST exprParentAST) {
        for (DetailAST currentNode : AvoidNotShortCircuitOperatorsForBooleanCheck.getChildren(exprParentAST)) {
            if (currentNode.getNumberOfChildren() > 0 && currentNode.getType() != 27) {
                this.getSupportedOperandsNames(currentNode);
            }
            if (currentNode.getType() == 58 && currentNode.getParent().getType() != 59) {
                this.supportedOperands.add(currentNode.getText());
            }
            if (currentNode.getNextSibling() == null) continue;
            DetailAST detailAST = currentNode.getNextSibling();
        }
        return this.supportedOperands;
    }

    public final boolean hasTrueOrFalseLiteral(DetailAST parentAST) {
        for (DetailAST currentNode : AvoidNotShortCircuitOperatorsForBooleanCheck.getChildren(parentAST)) {
            int type;
            if (currentNode.getNumberOfChildren() > 0) {
                this.hasTrueOrFalseLiteral(currentNode);
            }
            if ((type = currentNode.getType()) == 133 || type == 134) {
                this.hasTrueOrFalseLiteral = true;
            }
            if (currentNode.getNextSibling() != null) {
                currentNode = currentNode.getNextSibling();
            }
            if (!this.hasTrueOrFalseLiteral) continue;
            break;
        }
        return this.hasTrueOrFalseLiteral;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST currNode = node.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            result.add(currNode);
        }
        return result;
    }
}

