/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForbidCertainMethodCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.certain.method";
    private static final Pattern COMMA_REGEX = Pattern.compile(",");
    private Pattern methodName = CommonUtils.createPattern((String)"^$");
    private String argumentCount = "0-";
    private final List<IntRange> argumentCountRanges = new ArrayList<IntRange>(Collections.singletonList(new IntRange(0, Integer.MAX_VALUE)));

    public void setMethodName(String methodName) {
        this.methodName = CommonUtils.createPattern((String)methodName);
    }

    public void setArgumentCount(String argumentCount) throws CheckstyleException {
        this.argumentCount = argumentCount;
        if (argumentCount.trim().length() > 0) {
            String[] rangeTokens = COMMA_REGEX.split(argumentCount);
            this.argumentCountRanges.clear();
            for (String oneToken : rangeTokens) {
                this.argumentCountRanges.add(IntRange.from(oneToken));
            }
        } else {
            throw new CheckstyleException("argumentCount must be non-empty, found: " + argumentCount);
        }
    }

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{27};
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 27: {
                DetailAST dot = ast.getFirstChild();
                String methodNameInCode = dot.getType() == 58 ? dot.getText() : dot.getLastChild().getText();
                int numArgsInCode = dot.getNextSibling().getChildCount(28);
                if (!this.isForbiddenMethod(ast, methodNameInCode, numArgsInCode)) break;
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[]{methodNameInCode, this.methodName, numArgsInCode, this.argumentCount});
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private boolean isForbiddenMethod(DetailAST ast, String name, int argCount) {
        boolean matched = false;
        if (this.methodName.matcher(name).matches()) {
            for (IntRange intRange : this.argumentCountRanges) {
                if (!intRange.contains(argCount)) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    static class IntRange {
        private static final Pattern RANGE_PATTERN = Pattern.compile("^\\s*+(\\d*+)\\s*+-\\s*+(\\d*+)\\s*+$");
        private final int lowerLimit;
        private final int upperLimit;

        IntRange(int lowerLimit, int upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        static IntRange from(String range) throws CheckstyleException {
            int lowerLimit = 0;
            int upperLimit = Integer.MAX_VALUE;
            if (!range.contains("-")) {
                upperLimit = lowerLimit = Integer.parseInt(range.trim());
            } else {
                Matcher matcher = RANGE_PATTERN.matcher(range);
                if (!matcher.find()) {
                    throw new CheckstyleException("Specified range is not valid: " + range);
                }
                String lowerLimitString = matcher.group(1);
                String upperLimitString = matcher.group(2);
                if (lowerLimitString.length() == 0 && upperLimitString.length() == 0) {
                    throw new CheckstyleException("Specified range is unbounded on both side: " + range);
                }
                if (lowerLimitString.length() > 0) {
                    lowerLimit = Integer.parseInt(lowerLimitString);
                }
                if (upperLimitString.length() > 0) {
                    upperLimit = Integer.parseInt(upperLimitString);
                }
                if (lowerLimit > upperLimit) {
                    throw new CheckstyleException("Lower limit of the range is larger than the upper limit: " + range);
                }
            }
            return new IntRange(lowerLimit, upperLimit);
        }

        public boolean contains(int num) {
            return num >= this.lowerLimit && num <= this.upperLimit;
        }
    }
}

