/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class ForbidReturnInFinallyBlockCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.return.in.finally.block";

    public final int[] getDefaultTokens() {
        return new int[]{97};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST finallyNode) {
        DetailAST firstSlistNode = finallyNode.findFirstToken(7);
        List<DetailAST> listOfReturnNodes = this.getReturnNodes(firstSlistNode);
        for (DetailAST returnNode : listOfReturnNodes) {
            if (ForbidReturnInFinallyBlockCheck.isReturnInMethodDefinition(returnNode)) continue;
            this.log(finallyNode.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private List<DetailAST> getReturnNodes(DetailAST node) {
        ArrayList<DetailAST> result = new ArrayList<DetailAST>();
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() == 88) {
                result.add(child);
                break;
            }
            result.addAll(this.getReturnNodes(child));
        }
        return result;
    }

    private static boolean isReturnInMethodDefinition(DetailAST returnNode) {
        Boolean result = false;
        DetailAST node = returnNode;
        while (node.getType() != 97) {
            if (node.getType() == 9) {
                result = true;
                break;
            }
            node = node.getParent();
        }
        return result;
    }
}

