/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class OverridableMethodInConstructorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "overridable.method";
    public static final String MSG_KEY_LEADS = "overridable.method.leads";
    private static final String KEY_CTOR = "constructor";
    private static final String KEY_CLONE = "'clone()' method";
    private static final String KEY_READ_OBJECT = "'readObject()' method";
    private static final String LITERAL_THIS = "this";
    private static final String PATH_SEPARATOR = ".";
    private final List<DetailAST> visitedMethodCalls = new LinkedList<DetailAST>();
    private DetailAST curMethodDef;
    private DetailAST treeRootAST;
    private boolean checkCloneMethod;
    private boolean checkReadObjectMethod;
    private boolean matchMethodsByArgCount;
    private String curOverridableMetName;
    private int curMethodDefCount;

    public void setCheckCloneMethod(boolean value) {
        this.checkCloneMethod = value;
    }

    public void setMatchMethodsByArgCount(boolean value) {
        this.matchMethodsByArgCount = value;
    }

    public void setCheckReadObjectMethod(boolean value) {
        this.checkReadObjectMethod = value;
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST rootAST) {
        this.treeRootAST = rootAST;
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST classDef = OverridableMethodInConstructorCheck.getClassDef(detailAST);
        if (classDef != null && !OverridableMethodInConstructorCheck.hasModifier(classDef, 39)) {
            switch (detailAST.getType()) {
                case 8: {
                    this.logWarnings(detailAST, KEY_CTOR);
                    break;
                }
                case 9: {
                    String methodName = detailAST.findFirstToken(58).getText();
                    if (this.checkCloneMethod && "clone".equals(methodName) && this.realizesAnInterface(classDef, Cloneable.class.getSimpleName())) {
                        this.logWarnings(detailAST, KEY_CLONE);
                        break;
                    }
                    if (!this.checkReadObjectMethod || !"readObject".equals(methodName) || !this.realizesAnInterface(classDef, Serializable.class.getSimpleName())) break;
                    this.logWarnings(detailAST, KEY_READ_OBJECT);
                    break;
                }
                default: {
                    Utils.reportInvalidToken(detailAST.getType());
                }
            }
        }
    }

    private void logWarnings(DetailAST detailAST, String key) {
        List<OverridableMetCall> methodCallsToWarnList = this.getOverridables(detailAST);
        for (OverridableMetCall omc : methodCallsToWarnList) {
            DetailAST methodDef = this.getMethodDef(omc.metCallAST);
            if (OverridableMethodInConstructorCheck.hasModifier(methodDef, 61) || OverridableMethodInConstructorCheck.hasModifier(methodDef, 39)) {
                this.log(omc.metCallAST, MSG_KEY_LEADS, new Object[]{this.getMethodName(omc.metCallAST), key, omc.overridableMetName});
                continue;
            }
            this.log(omc.metCallAST, MSG_KEY, new Object[]{this.getMethodName(omc.metCallAST), key, omc.overridableMetName});
        }
    }

    private List<OverridableMetCall> getOverridables(DetailAST parentAST) {
        LinkedList<OverridableMetCall> result = new LinkedList<OverridableMetCall>();
        List<DetailAST> methodCallsList = this.getMethodCallsList(parentAST);
        for (DetailAST curNode : methodCallsList) {
            this.visitedMethodCalls.clear();
            DetailAST methodDef = this.getMethodDef(curNode);
            if (methodDef == null || OverridableMethodInConstructorCheck.getMethodParamsCount(curNode) != OverridableMethodInConstructorCheck.getMethodParamsCount(methodDef) || !this.isOverridableMethodCall(curNode)) continue;
            result.add(new OverridableMetCall(curNode, this.curOverridableMetName));
        }
        return result;
    }

    private boolean isOverridableMethodCall(DetailAST methodCallAST) {
        boolean result = false;
        this.visitedMethodCalls.add(methodCallAST);
        String methodName = this.getMethodName(methodCallAST);
        DetailAST methodDef = this.getMethodDef(methodCallAST);
        if (methodName != null && methodDef != null && !OverridableMethodInConstructorCheck.hasModifier(methodDef, 64)) {
            if (OverridableMethodInConstructorCheck.hasModifier(methodDef, 61) || OverridableMethodInConstructorCheck.hasModifier(methodDef, 39)) {
                List<DetailAST> methodCallsList = this.getMethodCallsList(methodDef);
                for (DetailAST curNode : methodCallsList) {
                    if (this.visitedMethodCalls.contains(curNode) || !this.isOverridableMethodCall(curNode)) continue;
                    result = true;
                    break;
                }
            } else {
                this.curOverridableMetName = methodName;
                result = true;
            }
        }
        return result;
    }

    private List<DetailAST> getMethodCallsList(DetailAST parentAST) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(parentAST)) {
            if (curNode.getNumberOfChildren() <= 0) continue;
            if (curNode.getType() == 27) {
                result.add(curNode);
                continue;
            }
            result.addAll(this.getMethodCallsList(curNode));
        }
        return result;
    }

    private String getMethodName(DetailAST methodCallAST) {
        String result = null;
        DetailAST ident = methodCallAST.findFirstToken(58);
        if (ident != null) {
            result = ident.getText();
        } else {
            DetailAST childAST = methodCallAST.getFirstChild();
            if (childAST != null && childAST.getType() == 59) {
                DetailAST firstChild = childAST.getFirstChild();
                DetailAST lastChild = childAST.getLastChild();
                if (firstChild.getType() == 78 || firstChild.getType() == 76 || firstChild.getType() == 59) {
                    result = lastChild.getText();
                } else if (firstChild.getType() == 58 && lastChild.getType() == 58) {
                    String curClassName = OverridableMethodInConstructorCheck.getClassDef(methodCallAST).findFirstToken(58).getText();
                    if (firstChild.getText().equals(curClassName) || OverridableMethodInConstructorCheck.getClassDef(this.treeRootAST, firstChild.getText()) != null) {
                        result = lastChild.getText();
                    }
                }
            }
        }
        return result;
    }

    private DetailAST getMethodDef(DetailAST methodCallAST) {
        DetailAST result = null;
        this.curMethodDef = null;
        this.curMethodDefCount = 0;
        String methodName = this.getMethodName(methodCallAST);
        if (methodName != null) {
            String variableTypeName;
            DetailAST curClassAST = OverridableMethodInConstructorCheck.getClassDef(methodCallAST);
            DetailAST callsChild = methodCallAST.getFirstChild();
            if (callsChild.getType() != 59 || (variableTypeName = OverridableMethodInConstructorCheck.getVariableType(methodCallAST)) == null || OverridableMethodInConstructorCheck.isItTypeOfCurrentClass(variableTypeName, curClassAST) || OverridableMethodInConstructorCheck.isItCallMethodViaKeywordThis(variableTypeName, curClassAST)) {
                this.getMethodDef(curClassAST, methodName);
            }
            if (this.curMethodDefCount == 0) {
                List<DetailAST> baseClasses = this.getBaseClasses(curClassAST);
                for (DetailAST curBaseClass : baseClasses) {
                    this.curMethodDef = null;
                    this.curMethodDefCount = 0;
                    this.getMethodDef(curBaseClass, methodName);
                    if (this.curMethodDefCount != 1) continue;
                    result = this.curMethodDef;
                    break;
                }
            } else if (this.curMethodDefCount == 1) {
                result = this.curMethodDef;
            } else if (this.matchMethodsByArgCount) {
                int sameDefinitionCounter = 0;
                int curMethodParamCount = OverridableMethodInConstructorCheck.getMethodParamsCount(methodCallAST);
                for (DetailAST currentDefinition : this.getMethodDef(curClassAST, methodName)) {
                    if (OverridableMethodInConstructorCheck.getMethodParamsCount(currentDefinition) != curMethodParamCount) continue;
                    result = currentDefinition;
                    ++sameDefinitionCounter;
                }
                if (sameDefinitionCounter > 1) {
                    result = null;
                }
            }
        }
        return result;
    }

    private List<DetailAST> getMethodDef(DetailAST parentAST, String methodName) {
        List<DetailAST> definitionsList = new LinkedList<DetailAST>();
        for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(parentAST)) {
            int type;
            String curMethodName;
            if (curNode.getNumberOfChildren() <= 0) continue;
            if (curNode.getType() == 9 && methodName.equals(curMethodName = curNode.findFirstToken(58).getText())) {
                this.curMethodDef = curNode;
                definitionsList.add(0, curNode);
                ++this.curMethodDefCount;
            }
            if ((type = curNode.getType()) == 14 || type == 8 || type == 5 || type == 19 || type == 9) continue;
            definitionsList = this.getMethodDef(curNode, methodName);
        }
        return definitionsList;
    }

    private static String getVariableType(DetailAST methodCall) {
        DetailAST callsChild = methodCall.getFirstChild();
        String typeName = "";
        if (callsChild.getType() == 59) {
            DetailAST dotChild = callsChild.getFirstChild();
            if (dotChild.getType() == 78) {
                typeName = LITERAL_THIS;
            } else if (callsChild.getChildCount(23) > 0) {
                DetailAST typeCast = callsChild.findFirstToken(23);
                DetailAST type = typeCast.getFirstChild().getFirstChild();
                typeName = type.getText();
            } else if (dotChild.getType() == 59) {
                typeName = dotChild.getFirstChild().getText() + PATH_SEPARATOR + dotChild.getLastChild().getText();
            }
        }
        return typeName;
    }

    private static boolean isItTypeOfCurrentClass(String objectTypeName, DetailAST classDefNode) {
        DetailAST className = classDefNode.findFirstToken(58);
        boolean result = false;
        if (objectTypeName.equals(className.getText())) {
            result = true;
        } else {
            DetailAST baseClass = classDefNode.findFirstToken(18);
            if (baseClass != null && objectTypeName.equals((baseClass = baseClass.getFirstChild()).getText())) {
                result = true;
            }
        }
        return result;
    }

    private static boolean isItCallMethodViaKeywordThis(String firstPartOfTheMethodCall, DetailAST classDefNode) {
        String className = classDefNode.findFirstToken(58).getText();
        return LITERAL_THIS.equals(firstPartOfTheMethodCall) || (className + PATH_SEPARATOR + LITERAL_THIS).equals(firstPartOfTheMethodCall);
    }

    private static int getMethodParamsCount(DetailAST methodDefOrCallAST) {
        int result = 0;
        DetailAST paramsParentAST = null;
        if (methodDefOrCallAST.getType() == 27) {
            paramsParentAST = methodDefOrCallAST.findFirstToken(34);
        } else if (methodDefOrCallAST.getType() == 9) {
            paramsParentAST = methodDefOrCallAST.findFirstToken(20);
        }
        if (paramsParentAST != null && paramsParentAST.getChildCount() != 0) {
            for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(paramsParentAST)) {
                if (curNode.getType() != 74) continue;
                ++result;
            }
            ++result;
        }
        return result;
    }

    private static boolean hasModifier(DetailAST methodOrClassDefAST, int modifierType) {
        boolean result = false;
        DetailAST modifiers = methodOrClassDefAST.findFirstToken(5);
        if (modifiers != null && modifiers.getChildCount() != 0) {
            for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(modifiers)) {
                if (curNode.getType() != modifierType) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static DetailAST getClassDef(DetailAST methodNode) {
        DetailAST curNode;
        for (curNode = methodNode; curNode != null && curNode.getType() != 14; curNode = curNode.getParent()) {
        }
        return curNode;
    }

    private static DetailAST getClassDef(DetailAST rootNode, String className) {
        DetailAST curNode = rootNode;
        while (curNode != null) {
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
            if (curNode == null || curNode.getType() != 14 || !curNode.findFirstToken(58).getText().equals(className)) continue;
            break;
        }
        return curNode;
    }

    private boolean realizesAnInterface(DetailAST classDefNode, String interfaceName) {
        boolean result = false;
        List<DetailAST> classWithBaseClasses = this.getBaseClasses(classDefNode);
        classWithBaseClasses.add(classDefNode);
        for (DetailAST classAST : classWithBaseClasses) {
            if (!OverridableMethodInConstructorCheck.implementsAnInterface(classAST, interfaceName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean implementsAnInterface(DetailAST classDefAST, String interfaceName) {
        boolean result = false;
        DetailAST implClause = classDefAST.findFirstToken(19);
        if (implClause != null) {
            for (DetailAST ident : OverridableMethodInConstructorCheck.getChildren(implClause)) {
                if (!ident.getText().equals(interfaceName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private List<DetailAST> getBaseClasses(DetailAST classDefNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        String baseClassName = OverridableMethodInConstructorCheck.getBaseClassName(classDefNode);
        if (baseClassName != null) {
            DetailAST curClass = OverridableMethodInConstructorCheck.getClassDef(this.treeRootAST, baseClassName);
            while (curClass != null) {
                result.add(curClass);
                baseClassName = OverridableMethodInConstructorCheck.getBaseClassName(curClass);
                if (baseClassName == null) break;
                curClass = OverridableMethodInConstructorCheck.getClassDef(this.treeRootAST, baseClassName);
            }
        }
        return result;
    }

    private static String getBaseClassName(DetailAST classDefNode) {
        String result = null;
        DetailAST extendsClause = classDefNode.findFirstToken(18);
        if (extendsClause != null) {
            DetailAST dot = extendsClause.findFirstToken(59);
            result = dot != null ? dot.findFirstToken(58).getText() : extendsClause.findFirstToken(58).getText();
        }
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }

    private final class OverridableMetCall {
        private DetailAST metCallAST;
        private String overridableMetName;

        private OverridableMetCall(DetailAST methodCallAST, String overridableMetName) {
            this.metCallAST = methodCallAST;
            this.overridableMetName = overridableMetName;
        }
    }
}

