/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;

public class RequireFailForTryCatchInJunitCheck
extends AbstractCheck {
    public static final String MSG_KEY = "require.fail";
    private static final String FQ_JUNIT_TEST = "org.junit.Test";
    private static final String FAIL = "fail";
    private boolean importTest;
    private boolean importAssert;
    private boolean importStaticFail;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{30, 152, 95};
    }

    public void beginTree(DetailAST rootAST) {
        this.importTest = false;
        this.importAssert = false;
        this.importStaticFail = false;
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 30: {
                String imprt = RequireFailForTryCatchInJunitCheck.getImportText(ast);
                if (FQ_JUNIT_TEST.equals(imprt)) {
                    this.importTest = true;
                }
                if (!"org.junit.Assert".equals(imprt)) break;
                this.importAssert = true;
                break;
            }
            case 152: {
                String staticImprt = RequireFailForTryCatchInJunitCheck.getImportText(ast);
                if (!"org.junit.Assert.fail".equals(staticImprt)) break;
                this.importStaticFail = true;
                break;
            }
            case 95: {
                this.examineTry(ast);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private void examineTry(DetailAST ast) {
        DetailAST last;
        DetailAST method = RequireFailForTryCatchInJunitCheck.getMethod(ast);
        if (this.isTestMethod(method) && ast.findFirstToken(96) != null && ((last = ast.findFirstToken(7).getLastChild().getPreviousSibling()) == null || last.getType() != 45 || !this.isValidFail(last.getPreviousSibling()))) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private boolean isTestMethod(DetailAST method) {
        return method != null && (this.importTest && AnnotationUtility.containsAnnotation((DetailAST)method, (String)"Test") || AnnotationUtility.containsAnnotation((DetailAST)method, (String)FQ_JUNIT_TEST));
    }

    private boolean isValidFail(DetailAST expression) {
        boolean result = false;
        if (expression.getFirstChild().getType() == 27) {
            DetailAST ident = expression.getFirstChild().getFirstChild();
            if (this.importAssert && ident.getType() == 59) {
                DetailAST firstChild = ident.getFirstChild();
                result = "Assert".equals(firstChild.getText()) && FAIL.equals(firstChild.getNextSibling().getText());
            } else if (this.importStaticFail) {
                result = FAIL.equals(ident.getText());
            }
        }
        return result;
    }

    private static DetailAST getMethod(DetailAST node) {
        DetailAST result = null;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type == 9) {
                result = token;
            }
            if (type == 9 || type == 181) break;
        }
        return result;
    }

    private static String getImportText(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow((DetailAST)ast) : FullIdent.createFullIdent((DetailAST)ast.getFirstChild().getNextSibling());
        return imp.getText();
    }
}

