/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.SevntuUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Jsr305AnnotationsCheck
extends AbstractCheck {
    public static final String MSG_ILLEGAL_CLASS_LEVEL_ANNOTATION = "jsr305.illegal.class.level.annotation";
    public static final String MSG_CONTRADICTING_CLASS_LEVEL_ANNOTATIONS = "jsr305.contradicting.class.level.annotations";
    public static final String MSG_PARAM_DEFINITIONS_WITH_CHECK = "jsr305.param.definitions.with.check.annotation";
    public static final String MSG_PARAM_DEFINITION_WITH_OVERRIDE = "jsr305.param.definition.with.override.annotation";
    public static final String MSG_PARAM_DEFINITION_WITH_NONNULL_BY_DEFAULT = "jsr305.param.definition.with.nonnull.by.default.annotation";
    public static final String MSG_PARAM_DEFINITION_WITH_NULLABLE_BY_DEFAULT = "jsr305.param.definition.with.nullable.by.default.annotation";
    public static final String MSG_PARAM_DEFINITION_WITH_RETURN_DEFAULT = "jsr305.param.definition.with.return.values.default.annotation";
    public static final String MSG_PARAM_NONNULL_AND_NULLABLE = "jsr305.param.nonnull.and.nullable.annotation";
    public static final String MSG_PRIMITIVES_WITH_NULLNESS_ANNOTATION = "jsr305.primitives.with.nullness.annotation";
    public static final String MSG_OVERRIDDEN_WITH_INCREASED_CONSTRAINT = "jsr305.overridden.definitions.with.increased.param.constraint";
    public static final String MSG_REDUNDANT_NONNULL_PARAM_ANNOTATION = "jsr305.redundant.nonnull.param.annotation";
    public static final String MSG_REDUNDANT_NULLABLE_PARAM_ANNOTATION = "jsr305.redundant.nullable.param.annotation";
    public static final String MSG_PARAMETER_WITHOUT_NULLNESS_ANNOTATION = "jsr305.parameter.without.nullness.annotation";
    public static final String MSG_RETURN_VALUE_WITH_NONNULL_BY_DEFAULT = "jsr305.return.value.with.nonnull.by.default.annotation";
    public static final String MSG_RETURN_VALUE_WITH_NULLABLE = "jsr305.return.value.with.nullable.annotation";
    public static final String MSG_CONTRADICTING_RETURN_VALUE_ANNOTATIONS = "jsr305.contradicting.return.value.annotations";
    public static final String MSG_OVERRIDDEN_METHOD_WITH_CHECK_RETURN_VALUE = "jsr305.overridden.method.with.check.return.value.annotation";
    public static final String MSG_REDUNDANT_NONNULL_BY_DEFAULT_ANNOTATION = "jsr305.redundant.nonnull.by.default.annotation";
    public static final String MSG_REDUNDANT_NULLABLE_BY_DEFAULT_ANNOTATION = "jsr305.redundant.nullable.by.default.annotation";
    public static final String MSG_VOID_WITH_CHECK_RETURN_VALUE_ANNOTATION = "jsr305.void.with.check.return.value.annotation";
    public static final String MSG_REDUNDANT_NONNULL_RETURN_ANNOTATION = "jsr305.redundant.nonnull.return.annotation";
    public static final String MSG_RETURN_WITHOUT_NULLNESS_ANNOTATION = "jsr305.return.without.nullness.annotation";
    public static final String MSG_OVERRIDDEN_METHODS_ALLOW_ONLY_NONNULL = "jsr305.overridden.methods.allow.only.nonnull";
    public static final String MSG_NEED_TO_INHERIT_PARAM_ANNOTATIONS = "jsr305.need.to.inherit.param.annotations";
    public static final String MSG_CONSTRUCTOR_WITH_RETURN_ANNOTATION = "jsr305.constructor.with.return.annotation";
    private static final String PKG_JAVAX_ANNOTATION = "javax.annotation";
    private static final Map<String, NullnessAnnotation> STRING2ANNOTATION = Jsr305AnnotationsCheck.createString2AnnotationMap();
    private String[] packages = new String[0];
    private String[] excludePackages = new String[0];
    private boolean allowOverridingReturnValue;
    private boolean allowOverridingParameter;
    private boolean packageExcluded;

    public final int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public final int[] getRequiredTokens() {
        return new int[0];
    }

    public final int[] getAcceptableTokens() {
        return new int[]{21, 9, 16, 8, 14, 15, 154};
    }

    public void beginTree(DetailAST rootAST) {
        this.packageExcluded = false;
    }

    public final void visitToken(DetailAST ast) {
        AbstractJsr305Handler handler;
        if (ast.getType() == 16) {
            DetailAST nameAST = ast.getLastChild().getPreviousSibling();
            this.packageExcluded = this.isPackageExcluded(FullIdent.createFullIdent((DetailAST)nameAST));
        } else if (!this.packageExcluded && (handler = this.handleDefinition(ast)) != null) {
            handler.handle();
        }
    }

    public void setPackages(String ... packageNames) {
        this.packages = Jsr305AnnotationsCheck.transformToUnique(packageNames);
    }

    public void setExcludePackages(String ... packageNames) {
        this.excludePackages = Jsr305AnnotationsCheck.transformToUnique(packageNames);
    }

    public void setAllowOverridingReturnValue(boolean newAllowOverridingReturnValue) {
        this.allowOverridingReturnValue = newAllowOverridingReturnValue;
    }

    public void setAllowOverridingParameter(boolean newAllowOverridingParameter) {
        this.allowOverridingParameter = newAllowOverridingParameter;
    }

    private static Map<String, NullnessAnnotation> createString2AnnotationMap() {
        HashMap<String, NullnessAnnotation> result = new HashMap<String, NullnessAnnotation>();
        for (NullnessAnnotation annotation : NullnessAnnotation.values()) {
            result.put(annotation.annotationName, annotation);
            result.put(annotation.fullyQualifiedClassName, annotation);
        }
        return Collections.unmodifiableMap(result);
    }

    private static String[] transformToUnique(String ... input) {
        HashSet<String> inputSet = new HashSet<String>(Arrays.asList(input));
        return inputSet.toArray(new String[0]);
    }

    private boolean isPackageExcluded(FullIdent fullIdent) {
        Boolean result = null;
        String packageName = fullIdent.getText();
        for (String excludesPackageName : this.excludePackages) {
            if (!packageName.startsWith(excludesPackageName)) continue;
            result = true;
            break;
        }
        if (result == null) {
            for (String includePackageName : this.packages) {
                if (!packageName.startsWith(includePackageName)) continue;
                result = false;
                break;
            }
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    private AbstractJsr305Handler handleDefinition(DetailAST ast) {
        DetailAST parent = ast.getParent();
        AbstractJsr305Handler result = null;
        if (parent == null || parent.getType() != 96) {
            int type = ast.getType();
            switch (type) {
                case 9: {
                    result = new MethodJsr305Handler(ast);
                    break;
                }
                case 8: {
                    result = new ConstructorJsr305Handler(ast);
                    break;
                }
                case 21: {
                    result = new ParameterJsr305Handler(ast);
                    break;
                }
                case 14: 
                case 15: 
                case 154: {
                    result = new ClassJsr305Handler(ast);
                    break;
                }
                default: {
                    SevntuUtil.reportInvalidToken(ast.getType());
                }
            }
        }
        return result;
    }

    private static Set<NullnessAnnotation> findAnnotations(DetailAST ast) {
        HashSet<NullnessAnnotation> result = new HashSet<NullnessAnnotation>();
        DetailAST modifiers = ast.findFirstToken(5);
        for (DetailAST child = modifiers.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 159) continue;
            Jsr305AnnotationsCheck.addNextNullnessAnnotation(result, child);
        }
        return result;
    }

    private static void addNextNullnessAnnotation(Set<NullnessAnnotation> result, DetailAST ast) {
        String annotationName;
        NullnessAnnotation annotation;
        DetailAST identifier = ast.findFirstToken(58);
        if (identifier != null && (annotation = STRING2ANNOTATION.get(annotationName = identifier.getText())) != null) {
            result.add(annotation);
        }
    }

    private static boolean isPrimitiveType(DetailAST ast) {
        boolean result = false;
        DetailAST parameterType = ast.findFirstToken(13);
        DetailAST identToken = parameterType.getFirstChild();
        if (identToken != null) {
            switch (identToken.getType()) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    result = !Jsr305AnnotationsCheck.isArrayOrElipsis(parameterType);
                    break;
                }
            }
        }
        return result;
    }

    private static boolean isArrayOrElipsis(DetailAST identToken) {
        boolean result;
        DetailAST next = identToken.getNextSibling();
        switch (next.getType()) {
            case 17: 
            case 171: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected static boolean isVoid(DetailAST ast) {
        DetailAST parameterType = ast.findFirstToken(13);
        boolean result = false;
        DetailAST identToken = parameterType.getFirstChild();
        result = identToken.getType() == 49;
        return result;
    }

    public abstract class AbstractJsr305Handler {
        private boolean violationFound;
        private final Set<NullnessAnnotation> annotations;
        private final DetailAST ast;

        private AbstractJsr305Handler(DetailAST ast) {
            this.ast = ast;
            this.violationFound = false;
            this.annotations = Jsr305AnnotationsCheck.findAnnotations(ast);
        }

        public final void handle() {
            this.runHandler();
        }

        protected abstract void runHandler();

        protected DetailAST getAst() {
            return this.ast;
        }

        protected void checkContainsAny(String msg, NullnessAnnotation ... search) {
            if (!this.violationFound && this.containsAny(search)) {
                this.violation(msg);
            }
        }

        private boolean containsAny(NullnessAnnotation ... search) {
            boolean result = false;
            if (!this.annotations.isEmpty()) {
                for (NullnessAnnotation obj : search) {
                    if (!this.annotations.contains((Object)obj)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        protected void checkContainsAll(String msg, NullnessAnnotation ... search) {
            if (!this.violationFound && this.containsAll(search)) {
                this.violation(msg);
            }
        }

        protected void checkRedundancyDueToClassLevelAnnotation(String msg, NullnessAnnotation ... search) {
            if (!this.violationFound) {
                for (NullnessAnnotation nullnessAnnotation : search) {
                    boolean parentIsAnnotated;
                    boolean thisIsAnnotated = this.annotations.contains((Object)nullnessAnnotation);
                    boolean bl = parentIsAnnotated = this.getParentMethodOrClassAnnotation(nullnessAnnotation) != null;
                    if (!thisIsAnnotated || !parentIsAnnotated) continue;
                    this.violation(msg);
                    break;
                }
            }
        }

        private boolean containsAll(NullnessAnnotation ... search) {
            boolean result = true;
            if (this.annotations.isEmpty()) {
                result = false;
            } else {
                for (NullnessAnnotation obj : search) {
                    if (this.annotations.contains((Object)obj)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }

        protected void checkContainsNone(String msg, NullnessAnnotation ... search) {
            if (!this.violationFound && !this.containsAny(search)) {
                this.violation(msg);
            }
        }

        private void violation(String msg) {
            Jsr305AnnotationsCheck.this.log(this.ast, msg, new Object[0]);
            this.violationFound = true;
        }

        protected NullnessAnnotation getParentMethodOrClassAnnotation(NullnessAnnotation ... annotationsToLookFor) {
            boolean finished = false;
            NullnessAnnotation result = null;
            for (DetailAST current = this.ast.getParent(); current != null && !finished; current = current.getParent()) {
                int tokenType = current.getType();
                if (this.isPossibleTokenTypeForNullnessAnnotations(tokenType)) {
                    Set<NullnessAnnotation> foundAndLookedFor = this.collectLookedForAnnotations(current, annotationsToLookFor);
                    if (foundAndLookedFor.size() == 1) {
                        result = foundAndLookedFor.iterator().next();
                        finished = true;
                    } else if (!foundAndLookedFor.isEmpty()) {
                        finished = true;
                    }
                }
                if (tokenType != 136 && tokenType != 14 && tokenType != 15 && tokenType != 154) continue;
                finished = true;
            }
            return result;
        }

        private boolean isPossibleTokenTypeForNullnessAnnotations(int tokenType) {
            return tokenType == 14 || tokenType == 15 || tokenType == 9 || tokenType == 8 || tokenType == 154;
        }

        private Set<NullnessAnnotation> collectLookedForAnnotations(DetailAST current, NullnessAnnotation ... annotationsToLookFor) {
            Set foundAnnotations = Jsr305AnnotationsCheck.findAnnotations(current);
            HashSet<NullnessAnnotation> foundAndLookedFor = new HashSet<NullnessAnnotation>();
            for (NullnessAnnotation nullnessAnnotation : annotationsToLookFor) {
                if (!foundAnnotations.contains((Object)nullnessAnnotation)) continue;
                foundAndLookedFor.add(nullnessAnnotation);
            }
            return foundAndLookedFor;
        }

        protected boolean isMethodOverridden() {
            Boolean result = null;
            block4: for (DetailAST current = this.ast; current != null && result == null; current = current.getParent()) {
                switch (current.getType()) {
                    case 9: {
                        result = Jsr305AnnotationsCheck.findAnnotations(current).contains((Object)NullnessAnnotation.OVERRIDE);
                        continue block4;
                    }
                    case 181: {
                        result = true;
                        continue block4;
                    }
                }
            }
            if (result == null) {
                result = false;
            }
            return result;
        }
    }

    private final class ConstructorJsr305Handler
    extends AbstractMethodJsr305Handler {
        protected ConstructorJsr305Handler(DetailAST ast) {
            super(ast);
        }

        @Override
        protected void runReturnAnnotationHandler() {
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_CONSTRUCTOR_WITH_RETURN_ANNOTATION, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.CHECK_RETURN_VALUE, NullnessAnnotation.NONNULL, NullnessAnnotation.NULLABLE, NullnessAnnotation.OVERRIDE);
        }
    }

    private final class MethodJsr305Handler
    extends AbstractMethodJsr305Handler {
        protected MethodJsr305Handler(DetailAST ast) {
            super(ast);
        }

        @Override
        protected void runReturnAnnotationHandler() {
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_RETURN_VALUE_WITH_NONNULL_BY_DEFAULT, NullnessAnnotation.RETURN_VALUES_ARE_NONNULL_BY_DEFAULT);
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_RETURN_VALUE_WITH_NULLABLE, NullnessAnnotation.NULLABLE);
            this.checkContainsAll(Jsr305AnnotationsCheck.MSG_CONTRADICTING_RETURN_VALUE_ANNOTATIONS, NullnessAnnotation.NONNULL, NullnessAnnotation.CHECK_FOR_NULL);
            this.checkContainsAll(Jsr305AnnotationsCheck.MSG_OVERRIDDEN_METHOD_WITH_CHECK_RETURN_VALUE, NullnessAnnotation.CHECK_RETURN_VALUE, NullnessAnnotation.OVERRIDE);
            this.checkRedundancyDueToClassLevelAnnotation(Jsr305AnnotationsCheck.MSG_REDUNDANT_NONNULL_BY_DEFAULT_ANNOTATION, NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT);
            this.checkRedundancyDueToClassLevelAnnotation(Jsr305AnnotationsCheck.MSG_REDUNDANT_NULLABLE_BY_DEFAULT_ANNOTATION, NullnessAnnotation.PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
            DetailAST ast = this.getAst();
            if (Jsr305AnnotationsCheck.isVoid(ast)) {
                this.checkContainsAny(Jsr305AnnotationsCheck.MSG_VOID_WITH_CHECK_RETURN_VALUE_ANNOTATION, NullnessAnnotation.CHECK_RETURN_VALUE);
            }
            if (Jsr305AnnotationsCheck.isPrimitiveType(ast)) {
                this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PRIMITIVES_WITH_NULLNESS_ANNOTATION, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.NONNULL, NullnessAnnotation.NULLABLE);
            } else {
                NullnessAnnotation annotation = this.getParentMethodOrClassAnnotation(NullnessAnnotation.RETURN_VALUES_ARE_NONNULL_BY_DEFAULT);
                boolean returnValuesAreNonnullByDefault = annotation == NullnessAnnotation.RETURN_VALUES_ARE_NONNULL_BY_DEFAULT;
                boolean isMethodOverridden = this.isMethodOverridden();
                if (returnValuesAreNonnullByDefault) {
                    if (!isMethodOverridden) {
                        this.checkContainsAny(Jsr305AnnotationsCheck.MSG_REDUNDANT_NONNULL_RETURN_ANNOTATION, NullnessAnnotation.NONNULL);
                    }
                } else {
                    this.checkContainsNone(Jsr305AnnotationsCheck.MSG_RETURN_WITHOUT_NULLNESS_ANNOTATION, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.NONNULL, NullnessAnnotation.OVERRIDE);
                }
                if (isMethodOverridden && !Jsr305AnnotationsCheck.this.allowOverridingReturnValue) {
                    this.checkContainsAny(Jsr305AnnotationsCheck.MSG_OVERRIDDEN_METHODS_ALLOW_ONLY_NONNULL, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.NULLABLE);
                }
                if (isMethodOverridden) {
                    this.checkContainsAny(Jsr305AnnotationsCheck.MSG_NEED_TO_INHERIT_PARAM_ANNOTATIONS, NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT);
                }
            }
        }
    }

    private abstract class AbstractMethodJsr305Handler
    extends AbstractJsr305Handler {
        private AbstractMethodJsr305Handler(DetailAST ast) {
            super(ast);
        }

        @Override
        protected void runHandler() {
            this.checkContainsAll(Jsr305AnnotationsCheck.MSG_CONTRADICTING_CLASS_LEVEL_ANNOTATIONS, NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT, NullnessAnnotation.PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
            this.runReturnAnnotationHandler();
        }

        protected abstract void runReturnAnnotationHandler();
    }

    private final class ParameterJsr305Handler
    extends AbstractJsr305Handler {
        protected ParameterJsr305Handler(DetailAST ast) {
            super(ast);
        }

        @Override
        protected void runHandler() {
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PARAM_DEFINITIONS_WITH_CHECK, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.CHECK_RETURN_VALUE);
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PARAM_DEFINITION_WITH_OVERRIDE, NullnessAnnotation.OVERRIDE);
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PARAM_DEFINITION_WITH_NONNULL_BY_DEFAULT, NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT);
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PARAM_DEFINITION_WITH_NULLABLE_BY_DEFAULT, NullnessAnnotation.PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PARAM_DEFINITION_WITH_RETURN_DEFAULT, NullnessAnnotation.RETURN_VALUES_ARE_NONNULL_BY_DEFAULT);
            this.checkContainsAll(Jsr305AnnotationsCheck.MSG_PARAM_NONNULL_AND_NULLABLE, NullnessAnnotation.NONNULL, NullnessAnnotation.NULLABLE);
            DetailAST ast = this.getAst();
            if (Jsr305AnnotationsCheck.isPrimitiveType(ast)) {
                this.checkContainsAny(Jsr305AnnotationsCheck.MSG_PRIMITIVES_WITH_NULLNESS_ANNOTATION, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.NONNULL, NullnessAnnotation.NULLABLE);
            } else {
                boolean parametersAreNullableByDefault;
                NullnessAnnotation firstAncestorAnnotation = this.getParentMethodOrClassAnnotation(NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT, NullnessAnnotation.PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
                boolean isMethodOverridden = this.isMethodOverridden();
                boolean parametersAreNonnullByDefault = firstAncestorAnnotation == NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT;
                boolean bl = parametersAreNullableByDefault = firstAncestorAnnotation == NullnessAnnotation.PARAMETERS_ARE_NULLABLE_BY_DEFAULT;
                if (isMethodOverridden && !Jsr305AnnotationsCheck.this.allowOverridingParameter) {
                    this.checkContainsAny(Jsr305AnnotationsCheck.MSG_OVERRIDDEN_WITH_INCREASED_CONSTRAINT, NullnessAnnotation.NONNULL);
                }
                if (parametersAreNonnullByDefault) {
                    this.checkContainsAny(Jsr305AnnotationsCheck.MSG_REDUNDANT_NONNULL_PARAM_ANNOTATION, NullnessAnnotation.NONNULL);
                }
                if (parametersAreNullableByDefault) {
                    this.checkContainsAny(Jsr305AnnotationsCheck.MSG_REDUNDANT_NULLABLE_PARAM_ANNOTATION, NullnessAnnotation.NULLABLE);
                }
                if (!(isMethodOverridden || parametersAreNonnullByDefault || parametersAreNullableByDefault)) {
                    this.checkContainsNone(Jsr305AnnotationsCheck.MSG_PARAMETER_WITHOUT_NULLNESS_ANNOTATION, NullnessAnnotation.NONNULL, NullnessAnnotation.NULLABLE);
                }
            }
        }
    }

    private final class ClassJsr305Handler
    extends AbstractJsr305Handler {
        protected ClassJsr305Handler(DetailAST ast) {
            super(ast);
        }

        @Override
        protected void runHandler() {
            this.checkContainsAny(Jsr305AnnotationsCheck.MSG_ILLEGAL_CLASS_LEVEL_ANNOTATION, NullnessAnnotation.CHECK_FOR_NULL, NullnessAnnotation.CHECK_RETURN_VALUE, NullnessAnnotation.NONNULL, NullnessAnnotation.NULLABLE);
            this.checkContainsAll(Jsr305AnnotationsCheck.MSG_CONTRADICTING_CLASS_LEVEL_ANNOTATIONS, NullnessAnnotation.PARAMETERS_ARE_NONNULL_BY_DEFAULT, NullnessAnnotation.PARAMETERS_ARE_NULLABLE_BY_DEFAULT);
        }
    }

    private static enum NullnessAnnotation {
        OVERRIDE("Override", "java.lang"),
        CHECK_FOR_NULL("CheckForNull", "javax.annotation"),
        NULLABLE("Nullable", "javax.annotation"),
        NONNULL("Nonnull", "javax.annotation"),
        CHECK_RETURN_VALUE("CheckReturnValue", "javax.annotation"),
        PARAMETERS_ARE_NONNULL_BY_DEFAULT("ParametersAreNonnullByDefault", "javax.annotation"),
        PARAMETERS_ARE_NULLABLE_BY_DEFAULT("ParametersAreNullableByDefault", "javax.annotation"),
        RETURN_VALUES_ARE_NONNULL_BY_DEFAULT("ReturnValuesAreNonnullByDefault", "edu.umd.cs.findbugs.annotations");

        private final String annotationName;
        private final String fullyQualifiedClassName;

        private NullnessAnnotation(String annotationName, String packageName) {
            this.annotationName = annotationName;
            this.fullyQualifiedClassName = packageName + "." + annotationName;
        }
    }
}

