/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ConfusingConditionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "confusing.condition.check";
    private static final int MULTIPLY_FACTOR_FOR_ELSE_BLOCK = 4;
    private int multiplyFactorForElseBlocks = 4;
    private boolean ignoreInnerIf = true;
    private boolean ignoreSequentialIf = true;
    private boolean ignoreNullCaseInIf = true;
    private boolean ignoreThrowInElse = true;

    public void setIgnoreInnerIf(boolean aIgnoreInnerIf) {
        this.ignoreInnerIf = aIgnoreInnerIf;
    }

    public void setIgnoreSequentialIf(boolean ignoreSequentialIf) {
        this.ignoreSequentialIf = ignoreSequentialIf;
    }

    public void setIgnoreNullCaseInIf(boolean ignoreNullCaseInIf) {
        this.ignoreNullCaseInIf = ignoreNullCaseInIf;
    }

    public void setIgnoreThrowInElse(boolean ignoreThrowInElse) {
        this.ignoreThrowInElse = ignoreThrowInElse;
    }

    public void setMultiplyFactorForElseBlocks(int multiplyFactorForElseBlocks) {
        this.multiplyFactorForElseBlocks = multiplyFactorForElseBlocks;
    }

    public int[] getDefaultTokens() {
        return new int[]{83};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST literalIf) {
        if (ConfusingConditionCheck.isIfEndsWithElse(literalIf) && !this.canIgnore(literalIf) && this.isRatioBetweenIfAndElseBlockSuitable(literalIf) && ConfusingConditionCheck.isConditionAllNegative(literalIf)) {
            this.log(literalIf, MSG_KEY, new Object[0]);
        }
    }

    private boolean canIgnore(DetailAST literalIf) {
        return this.ignoreSequentialIf && ConfusingConditionCheck.isSequentialIf(literalIf) || this.ignoreInnerIf && ConfusingConditionCheck.isInnerIf(literalIf) || this.ignoreThrowInElse && ConfusingConditionCheck.isElseWithThrow(literalIf) || this.ignoreNullCaseInIf && ConfusingConditionCheck.isIfWithNull(literalIf);
    }

    private static boolean isIfEndsWithElse(DetailAST literalIf) {
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        return lastChildAfterIf.getType() == 92;
    }

    private static boolean isSequentialIf(DetailAST literalIf) {
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        return lastChildAfterIf.getFirstChild().getType() == 83;
    }

    private static boolean isInnerIf(DetailAST literalIf) {
        DetailAST childIf = literalIf.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        return childIf.branchContains(83);
    }

    private static boolean isElseWithThrow(DetailAST literalIf) {
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        return lastChildAfterIf.getFirstChild().branchContains(90);
    }

    private boolean isRatioBetweenIfAndElseBlockSuitable(DetailAST literalIf) {
        boolean result = true;
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        int linesOfCodeInElseBlock = ConfusingConditionCheck.getAmountOfCodeRowsInBlock(lastChildAfterIf);
        if (linesOfCodeInElseBlock > 0) {
            int linesOfCodeInIfBlock = ConfusingConditionCheck.getAmountOfCodeRowsInBlock(literalIf);
            result = linesOfCodeInIfBlock / linesOfCodeInElseBlock < this.multiplyFactorForElseBlocks;
        }
        return result;
    }

    private static int getAmountOfCodeRowsInBlock(DetailAST detailAST) {
        int linesOfCodeInIfBlock;
        DetailAST firstBrace = ConfusingConditionCheck.getFirstBrace(detailAST);
        if (firstBrace == null) {
            linesOfCodeInIfBlock = 0;
        } else {
            DetailAST lastBrace = firstBrace.getLastChild();
            linesOfCodeInIfBlock = lastBrace.getLineNo() - firstBrace.getLineNo();
            if (lastBrace.getLineNo() != lastBrace.getParent().getLineNo()) {
                --linesOfCodeInIfBlock;
            }
        }
        return linesOfCodeInIfBlock;
    }

    private static DetailAST getFirstBrace(DetailAST detailAST) {
        DetailAST firstBrace = null;
        if (detailAST.getType() == 92) {
            firstBrace = detailAST.getFirstChild();
            if (firstBrace.getType() == 83) {
                firstBrace = ConfusingConditionCheck.getFirstBrace(firstBrace);
            }
        } else {
            firstBrace = detailAST.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        }
        if (firstBrace != null && firstBrace.getType() != 7) {
            firstBrace = null;
        }
        return firstBrace;
    }

    private static boolean isConditionAllNegative(DetailAST literalIf) {
        int countOfLor;
        int countOfLand;
        int countOfComparisonOperators;
        int countOfNotequal;
        boolean result = false;
        DetailAST ifExpr = literalIf.getFirstChild().getNextSibling();
        int countOfLnot = ConfusingConditionCheck.getCountOfToken(ifExpr, 132);
        int countOfNegativeSymbolInIf = countOfLnot + (countOfNotequal = ConfusingConditionCheck.getCountOfToken(ifExpr, 115));
        if (countOfNegativeSymbolInIf > 0 && countOfNegativeSymbolInIf - (countOfComparisonOperators = (countOfLand = ConfusingConditionCheck.getCountOfToken(ifExpr, 111)) + (countOfLor = ConfusingConditionCheck.getCountOfToken(ifExpr, 110))) == 1) {
            result = true;
        }
        return result;
    }

    private static boolean isIfWithNull(DetailAST literalIf) {
        return literalIf.getFirstChild().getNextSibling().branchContains(135);
    }

    private static int getCountOfToken(DetailAST detAst, int type) {
        int count = 0;
        if (detAst.branchContains(type)) {
            for (DetailAST node = detAst; node != null; node = node.getNextSibling()) {
                count += node.getChildCount(type);
                DetailAST detAstChild = node.getFirstChild();
                if (detAstChild == null) continue;
                count += ConfusingConditionCheck.getCountOfToken(detAstChild, type);
            }
        }
        return count;
    }
}

