/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class UnnecessaryParenthesesExtendedCheck
extends AbstractCheck {
    public static final String MSG_KEY_ASSIGN = "unnecessary.paren.assign";
    public static final String MSG_KEY_EXPR = "unnecessary.paren.expr";
    public static final String MSG_KEY_IDENT = "unnecessary.paren.ident";
    public static final String MSG_KEY_LITERAL = "unnecessary.paren.literal";
    public static final String MSG_KEY_RETURN = "unnecessary.paren.return";
    public static final String MSG_KEY_STRING = "unnecessary.paren.string";
    private static final int MIN_CHILDREN_FOR_MATCH = 3;
    private static final int MAX_QUOTED_LENGTH = 25;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private static final int[] EQUALS = new int[]{116, 115, 110, 111, 112};
    private boolean ignoreCalculationOfBooleanVariables;
    private boolean ignoreCalculationOfBooleanVariablesWithReturn;
    private boolean ignoreCalculationOfBooleanVariablesWithAssert;
    private DetailAST parentToSkip;
    private int assignDepth;

    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type != 80 || parent.getType() != 160) {
            boolean surrounded = UnnecessaryParenthesesExtendedCheck.isSurrounded(ast);
            if (surrounded && type == 58) {
                this.parentToSkip = ast.getParent();
                this.log(ast, MSG_KEY_IDENT, new Object[]{ast.getText()});
            } else if (surrounded && UnnecessaryParenthesesExtendedCheck.inTokenList(type, LITERALS)) {
                this.parentToSkip = ast.getParent();
                if (type == 139) {
                    this.log(ast, MSG_KEY_STRING, new Object[]{UnnecessaryParenthesesExtendedCheck.chopString(ast.getText())});
                } else {
                    this.log(ast, MSG_KEY_LITERAL, new Object[]{ast.getText()});
                }
            } else if (UnnecessaryParenthesesExtendedCheck.inTokenList(type, ASSIGNMENTS)) {
                ++this.assignDepth;
                DetailAST last = ast.getLastChild();
                if (last.getType() == 77) {
                    DetailAST subtree = ast.getFirstChild().getNextSibling().getNextSibling();
                    int subtreeType = subtree.getType();
                    if (!this.ignoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(subtreeType, EQUALS)) {
                        this.log(ast, MSG_KEY_ASSIGN, new Object[0]);
                    }
                }
            }
        }
    }

    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type != 80 || parent.getType() != 160) {
            if (type == 28) {
                this.leaveTokenExpression(ast);
                this.parentToSkip = null;
            } else if (UnnecessaryParenthesesExtendedCheck.inTokenList(type, ASSIGNMENTS)) {
                --this.assignDepth;
            }
            super.leaveToken(ast);
        }
    }

    private void leaveTokenExpression(DetailAST ast) {
        if (this.parentToSkip != ast && UnnecessaryParenthesesExtendedCheck.exprSurrounded(ast)) {
            if (this.assignDepth >= 1) {
                if (!this.ignoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                    this.log(ast, MSG_KEY_ASSIGN, new Object[0]);
                }
            } else if (ast.getParent().getType() == 88) {
                if (!this.ignoreCalculationOfBooleanVariablesWithReturn || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                    this.log(ast, MSG_KEY_RETURN, new Object[0]);
                }
            } else if (ast.getParent().getType() == 151) {
                if (!this.ignoreCalculationOfBooleanVariablesWithAssert || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                    this.log(ast, MSG_KEY_EXPR, new Object[0]);
                }
            } else if (!this.ignoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                this.log(ast, MSG_KEY_EXPR, new Object[0]);
            }
        }
    }

    private static boolean isSurrounded(DetailAST ast) {
        DetailAST prev = ast.getPreviousSibling();
        DetailAST next = ast.getNextSibling();
        return prev != null && next != null && prev.getType() == 76;
    }

    private static boolean exprSurrounded(DetailAST ast) {
        return ast.getChildCount() >= 3;
    }

    private static boolean inTokenList(int type, int ... tokens) {
        boolean found = false;
        for (int i = 0; i < tokens.length && !found; ++i) {
            found = tokens[i] == type;
        }
        return found;
    }

    private static String chopString(String string) {
        String result = string.length() > 25 ? string.substring(0, 25) + "...\"" : string;
        return result;
    }

    private static int subtreeType(DetailAST ast) {
        DetailAST subtree = ast.getFirstChild().getNextSibling();
        return subtree.getType();
    }

    public final void setIgnoreCalculationOfBooleanVariables(boolean ignoreCalculationOfBooleanVariables) {
        this.ignoreCalculationOfBooleanVariables = ignoreCalculationOfBooleanVariables;
    }

    public final void setIgnoreCalculationOfBooleanVariablesWithReturn(boolean ignoreCalculationOfBooleanVariablesWithReturn) {
        this.ignoreCalculationOfBooleanVariablesWithReturn = ignoreCalculationOfBooleanVariablesWithReturn;
    }

    public final void setIgnoreCalculationOfBooleanVariablesWithAssert(boolean ignoreCalculationOfBooleanVariablesWithAssert) {
        this.ignoreCalculationOfBooleanVariablesWithAssert = ignoreCalculationOfBooleanVariablesWithAssert;
    }
}

