/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.SevntuUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.regex.Pattern;

public class ForbidCertainImportsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.certain.imports";
    private Pattern packageNamesRegexp;
    private Pattern forbiddenImportsRegexp;
    private Pattern forbiddenImportsExcludesRegexp;
    private boolean packageMatches;

    public void setPackageNameRegexp(String packageNameRegexp) {
        if (packageNameRegexp != null) {
            this.packageNamesRegexp = Pattern.compile(packageNameRegexp);
        }
    }

    public String getForbiddenImportRegexp() {
        return this.forbiddenImportsRegexp.toString();
    }

    public void setForbiddenImportsRegexp(String forbiddenImportsRegexp) {
        if (forbiddenImportsRegexp != null) {
            this.forbiddenImportsRegexp = Pattern.compile(forbiddenImportsRegexp);
        }
    }

    public void setForbiddenImportsExcludesRegexp(String forbiddenImportsExcludesRegexp) {
        if (forbiddenImportsExcludesRegexp != null) {
            this.forbiddenImportsExcludesRegexp = Pattern.compile(forbiddenImportsExcludesRegexp);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 30, 136};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST rootAST) {
        this.packageMatches = false;
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                if (this.packageNamesRegexp == null) break;
                String packageQualifiedName = ForbidCertainImportsCheck.getText(ast);
                this.packageMatches = this.packageNamesRegexp.matcher(packageQualifiedName).matches();
                break;
            }
            case 30: {
                String importQualifiedText = ForbidCertainImportsCheck.getText(ast);
                if (!this.isImportForbidden(importQualifiedText)) break;
                this.log(ast, importQualifiedText);
                break;
            }
            case 136: {
                String classQualifiedText;
                if (ast.findFirstToken(59) == null || !this.isImportForbidden(classQualifiedText = ForbidCertainImportsCheck.getText(ast))) break;
                this.log(ast, classQualifiedText);
                break;
            }
            default: {
                SevntuUtil.reportInvalidToken(ast.getType());
            }
        }
    }

    private boolean isImportForbidden(String importText) {
        return this.packageMatches && this.forbiddenImportsRegexp != null && this.forbiddenImportsRegexp.matcher(importText).matches() && (this.forbiddenImportsExcludesRegexp == null || !this.forbiddenImportsExcludesRegexp.matcher(importText).matches());
    }

    private void log(DetailAST nodeToWarn, String importText) {
        this.log(nodeToWarn, MSG_KEY, new Object[]{this.getForbiddenImportRegexp(), importText});
    }

    private static String getText(DetailAST packageDefOrImportNode) {
        String result;
        DetailAST identNode = packageDefOrImportNode.findFirstToken(58);
        if (identNode == null) {
            DetailAST parentDotAST = packageDefOrImportNode.findFirstToken(59);
            FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
            DetailAST nameAST = parentDotAST.getLastChild();
            result = dottedPathIdent.getText() + "." + nameAST.getText();
        } else {
            result = identNode.getText();
        }
        return result;
    }
}

