/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public final class IllegalCatchExtendedCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.catch";
    private final Set<String> illegalClassNames = Arrays.stream(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"}).collect(Collectors.toSet());
    private boolean allowThrow = true;
    private boolean allowRethrow = true;

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        for (String name : classNames) {
            this.illegalClassNames.add(name);
            int lastDot = name.lastIndexOf(46);
            if (lastDot <= 0 || lastDot >= name.length() - 1) continue;
            String shortName = name.substring(name.lastIndexOf(46) + 1);
            this.illegalClassNames.add(shortName);
        }
    }

    public void setAllowThrow(boolean value) {
        this.allowThrow = value;
    }

    public void setAllowRethrow(boolean value) {
        this.allowRethrow = value;
    }

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST paramDef = detailAST.findFirstToken(21);
        DetailAST throwAST = this.getThrowAST(detailAST);
        DetailAST firstLvlChild = null;
        if (throwAST != null) {
            firstLvlChild = throwAST.getFirstChild();
        }
        DetailAST secondLvlChild = null;
        if (firstLvlChild != null) {
            secondLvlChild = firstLvlChild.getFirstChild();
        }
        boolean noWarning = secondLvlChild != null && (this.allowThrow && secondLvlChild.getType() == 58 || this.allowRethrow && secondLvlChild.getType() == 136);
        DetailAST excType = paramDef.findFirstToken(13);
        FullIdent ident = CheckUtil.createFullType((DetailAST)excType);
        if (!noWarning && this.isIllegalClassName(ident.getText())) {
            this.log(detailAST, MSG_KEY, new Object[]{ident.getText()});
        }
    }

    public DetailAST getThrowAST(DetailAST parentAST) {
        DetailAST[] asts;
        DetailAST result = null;
        for (DetailAST currentNode : asts = IllegalCatchExtendedCheck.getChilds(parentAST)) {
            if (currentNode.getType() != 21 && currentNode.getFirstChild() != null) {
                result = this.getThrowAST(currentNode);
            }
            if (currentNode.getType() == 90) {
                result = currentNode;
            }
            if (result != null) break;
        }
        return result;
    }

    private static DetailAST[] getChilds(DetailAST node) {
        DetailAST[] result = new DetailAST[node.getChildCount()];
        DetailAST currNode = node.getFirstChild();
        for (int i = 0; i < result.length; ++i) {
            result[i] = currNode;
            currNode = currNode.getNextSibling();
        }
        return result;
    }

    protected boolean isIllegalClassName(String ident) {
        return this.illegalClassNames.contains(ident);
    }
}

