/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.github.sevntu.checkstyle.SevntuUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PublicReferenceToPrivateTypeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "public.reference.to.private.type";
    private final Set<DetailAST> privateTypes = new HashSet<DetailAST>();
    private final Set<DetailAST> externallyReferencedTypes = new HashSet<DetailAST>();

    public int[] getDefaultTokens() {
        return new int[]{14, 9, 15, 154, 10};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST rootAST) {
        this.privateTypes.clear();
        this.externallyReferencedTypes.clear();
    }

    public void visitToken(DetailAST defAst) {
        switch (defAst.getType()) {
            case 14: 
            case 15: 
            case 154: {
                if (!PublicReferenceToPrivateTypeCheck.hasModifier(61, defAst)) break;
                this.addPrivateTypes(defAst);
                break;
            }
            case 9: {
                if (!PublicReferenceToPrivateTypeCheck.isDefinedInTopLevelClass(defAst) || PublicReferenceToPrivateTypeCheck.hasModifier(61, defAst)) break;
                this.addExternallyAccessibleMethodTypes(defAst);
                break;
            }
            case 10: {
                if (!PublicReferenceToPrivateTypeCheck.isDefinedInTopLevelClass(defAst) || PublicReferenceToPrivateTypeCheck.hasModifier(61, defAst)) break;
                this.addExternallyAccessibleFieldTypes(defAst);
                break;
            }
            default: {
                SevntuUtil.reportInvalidToken(defAst.getType());
            }
        }
    }

    public void finishTree(DetailAST rootAst) {
        for (DetailAST privateType : this.privateTypes) {
            for (DetailAST outReturnedType : this.externallyReferencedTypes) {
                if (!privateType.getText().equals(outReturnedType.getText()) || this.isExtendsOrImplementsSmth(privateType.getParent())) continue;
                this.log(outReturnedType, MSG_KEY, new Object[]{outReturnedType.getText()});
            }
        }
    }

    private void addPrivateTypes(DetailAST classOrInterfaceOrEnumDefAst) {
        DetailAST definitionAst = classOrInterfaceOrEnumDefAst.findFirstToken(58);
        this.privateTypes.add(definitionAst);
    }

    private void addExternallyAccessibleMethodTypes(DetailAST methodDefAst) {
        DetailAST typeDefAst = methodDefAst.findFirstToken(13);
        DetailAST parametersDefAst = methodDefAst.findFirstToken(20);
        this.externallyReferencedTypes.addAll(PublicReferenceToPrivateTypeCheck.getMethodOrFieldReferencedTypes(typeDefAst));
        this.externallyReferencedTypes.addAll(PublicReferenceToPrivateTypeCheck.getMethodParameterTypes(parametersDefAst));
    }

    private void addExternallyAccessibleFieldTypes(DetailAST fieldDefAst) {
        DetailAST typeDefAst = fieldDefAst.findFirstToken(13);
        this.externallyReferencedTypes.addAll(PublicReferenceToPrivateTypeCheck.getMethodOrFieldReferencedTypes(typeDefAst));
    }

    private static List<DetailAST> getMethodOrFieldReferencedTypes(DetailAST typeAst) {
        ArrayList<DetailAST> returnedTypes = new ArrayList<DetailAST>();
        DetailAST currentNode = typeAst;
        while (currentNode != null) {
            if (currentNode.getType() == 58) {
                DetailAST returnedType = currentNode;
                returnedTypes.add(returnedType);
            }
            currentNode = SevntuUtil.getNextSubTreeNode(currentNode, typeAst);
        }
        return returnedTypes;
    }

    private static List<DetailAST> getMethodParameterTypes(DetailAST parametersDefAst) {
        ArrayList<DetailAST> parameterTypes = new ArrayList<DetailAST>();
        if (parametersDefAst.getFirstChild() != null) {
            DetailAST currentNode = parametersDefAst;
            while (currentNode != null) {
                if (currentNode.getType() == 21) {
                    DetailAST parameterType = currentNode;
                    while (parameterType != null) {
                        if ((parameterType = SevntuUtil.getNextSubTreeNode(parameterType, currentNode)) == null || parameterType.getType() != 58) continue;
                        parameterTypes.add(parameterType);
                    }
                }
                currentNode = SevntuUtil.getNextSubTreeNode(currentNode, parametersDefAst);
            }
        }
        return parameterTypes;
    }

    private boolean isExtendsOrImplementsSmth(DetailAST classOrInterfaceDefAst) {
        return (classOrInterfaceDefAst.findFirstToken(18) != null || classOrInterfaceDefAst.findFirstToken(19) != null) && !this.isExtendsOrImplementsPrivate(classOrInterfaceDefAst);
    }

    private boolean isExtendsOrImplementsPrivate(DetailAST classOrInterfaceDefAst) {
        boolean result = false;
        HashSet<String> inheritedTypesNamesSet = new HashSet<String>();
        DetailAST currentNode = classOrInterfaceDefAst;
        while (currentNode != null) {
            if (currentNode.getType() == 18 || currentNode.getType() == 19) {
                DetailAST implementingOrExtendingAst = currentNode;
                while (implementingOrExtendingAst != null) {
                    if ((implementingOrExtendingAst = SevntuUtil.getNextSubTreeNode(implementingOrExtendingAst, currentNode)) == null || implementingOrExtendingAst.getType() != 58) continue;
                    inheritedTypesNamesSet.add(implementingOrExtendingAst.getText());
                }
            }
            currentNode = SevntuUtil.getNextSubTreeNode(currentNode, classOrInterfaceDefAst);
        }
        HashSet<String> existingPrivateTypes = new HashSet<String>();
        for (DetailAST privateType : this.privateTypes) {
            existingPrivateTypes.add(privateType.getText());
        }
        if (existingPrivateTypes.containsAll(inheritedTypesNamesSet)) {
            result = true;
        }
        return result;
    }

    public static boolean hasModifier(int modifierType, DetailAST defAst) {
        DetailAST modifiersToken = defAst.getFirstChild();
        return modifiersToken.findFirstToken(modifierType) != null;
    }

    private static boolean isDefinedInTopLevelClass(DetailAST methodOrFieldDefAst) {
        return methodOrFieldDefAst.getParent().getParent().getParent() == null;
    }
}

