/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class AvoidDefaultSerializableInInnerClassesCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.default.serializable.in.inner.classes";
    private boolean allowPartialImplementation;

    public void setAllowPartialImplementation(boolean allow) {
        this.allowPartialImplementation = allow;
    }

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST detailAST) {
        boolean topLevelClass;
        boolean bl = topLevelClass = detailAST.getParent().getType() == 1;
        if (!topLevelClass && AvoidDefaultSerializableInInnerClassesCheck.isSerializable(detailAST) && !AvoidDefaultSerializableInInnerClassesCheck.isStatic(detailAST) && !this.hasSerialazableMethods(detailAST)) {
            DetailAST implementsBlock = detailAST.findFirstToken(19);
            this.log(implementsBlock, MSG_KEY, new Object[0]);
        }
    }

    private static boolean isStatic(DetailAST classNode) {
        boolean result = false;
        DetailAST modifiers = classNode.findFirstToken(5);
        for (modifiers = modifiers.getFirstChild(); !result && modifiers != null; modifiers = modifiers.getNextSibling()) {
            result = "static".equals(modifiers.getText());
        }
        return result;
    }

    private boolean hasSerialazableMethods(DetailAST classNode) {
        DetailAST objectBody = classNode.findFirstToken(6);
        int numberOfSerializationMethods = 0;
        SiblingIterator methodsIter = new SiblingIterator(objectBody);
        boolean result = false;
        while (methodsIter.hasNextSibling()) {
            DetailAST methodNode = methodsIter.nextSibling();
            if (AvoidDefaultSerializableInInnerClassesCheck.isPrivateMethod(methodNode) && AvoidDefaultSerializableInInnerClassesCheck.isVoidMethod(methodNode) && (AvoidDefaultSerializableInInnerClassesCheck.hasCorrectParameter(methodNode, "ObjectInputStream") || AvoidDefaultSerializableInInnerClassesCheck.hasCorrectParameter(methodNode, "ObjectOutputStream"))) {
                ++numberOfSerializationMethods;
            }
            if ((numberOfSerializationMethods != 1 || !this.allowPartialImplementation) && numberOfSerializationMethods != 2) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isPrivateMethod(DetailAST methodNode) {
        DetailAST modifiers = methodNode.findFirstToken(5);
        boolean isPrivate = false;
        for (modifiers = modifiers.getFirstChild(); !isPrivate && modifiers != null; modifiers = modifiers.getNextSibling()) {
            isPrivate = "private".equals(modifiers.getText());
        }
        return isPrivate;
    }

    private static boolean isVoidMethod(DetailAST methodNode) {
        DetailAST type = methodNode.findFirstToken(13);
        return 49 == (type = type.getFirstChild()).getType();
    }

    private static boolean hasCorrectParameter(DetailAST methodNode, String parameterText) {
        DetailAST parameters = methodNode.findFirstToken(20);
        boolean result = false;
        if (parameters.getChildCount(21) == 1) {
            parameters = parameters.findFirstToken(21);
            parameters = parameters.findFirstToken(13);
            parameters = parameters.getFirstChild();
            result = parameterText.equals(parameters.getText());
        }
        return result;
    }

    private static boolean isSerializable(DetailAST classDefNode) {
        DetailAST implementationsDef = classDefNode.findFirstToken(19);
        boolean result = false;
        if (implementationsDef != null) {
            for (implementationsDef = implementationsDef.getFirstChild(); !result && implementationsDef != null; implementationsDef = implementationsDef.getNextSibling()) {
                if (implementationsDef.getType() == 59) {
                    implementationsDef = implementationsDef.getLastChild();
                }
                result = "Serializable".equals(implementationsDef.getText());
            }
        }
        return result;
    }

    private final class SiblingIterator {
        private DetailAST next;

        SiblingIterator(DetailAST parent) {
            this.next = parent.findFirstToken(9);
        }

        public boolean hasNextSibling() {
            return this.next != null;
        }

        public DetailAST nextSibling() {
            DetailAST result = this.next;
            while (this.next != null) {
                this.next = this.next.getNextSibling();
                if (this.next == null || this.next.getType() != 9) continue;
                break;
            }
            return result;
        }
    }
}

