/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.SevntuUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RequireFailForTryCatchInJunitCheck
extends AbstractCheck {
    public static final String MSG_KEY = "require.fail";
    private static final List<String> FQ_JUNIT_TESTS = Arrays.asList("org.junit.Test", "org.junit.jupiter.api.Test");
    private static final Set<String> FAIL_METHODS = new HashSet<String>(Arrays.asList("com.google.common.truth.Truth#assert_.fail", "com.google.common.truth.Truth#assertWithMessage.fail", "junit.framework.Assert#fail", "org.assertj.core.api.Assertions#fail", "org.assertj.core.api.Assertions#failBecauseExceptionWasNotThrown", "org.junit.Assert#fail", "org.junit.jupiter.api.Assertions#fail"));
    private static final Map<String, List<String>> FAIL_METHOD_CALLS_BY_IMPORT = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> FAIL_METHOD_CALLS_BY_STATIC_IMPORT = new HashMap<String, List<String>>();
    private static final char CHAR_DOT = '.';
    private static final char CHAR_HASH = '#';
    private static final Set<String> FAIL_METHODS_WITH_DOTS = FAIL_METHODS.stream().map(entry -> entry.replace('#', '.')).collect(Collectors.toSet());
    private final Set<String> acceptedFailMethodCalls = new HashSet<String>(FAIL_METHODS_WITH_DOTS);
    private boolean importTest;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{30, 152, 95};
    }

    public void beginTree(DetailAST rootAST) {
        this.importTest = false;
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 30: {
                String imprt = RequireFailForTryCatchInJunitCheck.getImportText(ast);
                if (FQ_JUNIT_TESTS.contains(imprt)) {
                    this.importTest = true;
                    break;
                }
                List<String> failMethodCalls = FAIL_METHOD_CALLS_BY_IMPORT.get(imprt);
                if (failMethodCalls == null) break;
                this.acceptedFailMethodCalls.addAll(failMethodCalls);
                break;
            }
            case 152: {
                String staticImprt = RequireFailForTryCatchInJunitCheck.getImportText(ast);
                List<String> failMethodCall = FAIL_METHOD_CALLS_BY_STATIC_IMPORT.get(staticImprt);
                if (failMethodCall == null) break;
                this.acceptedFailMethodCalls.addAll(failMethodCall);
                break;
            }
            case 95: {
                this.examineTry(ast);
                break;
            }
            default: {
                SevntuUtil.reportInvalidToken(ast.getType());
            }
        }
    }

    private void examineTry(DetailAST ast) {
        DetailAST method = RequireFailForTryCatchInJunitCheck.getMethod(ast);
        if (this.isTestMethod(method) && ast.findFirstToken(96) != null) {
            boolean isValid;
            DetailAST last = ast.findFirstToken(7).getLastChild().getPreviousSibling();
            if (last == null) {
                isValid = false;
            } else {
                switch (last.getType()) {
                    case 90: {
                        isValid = true;
                        break;
                    }
                    case 45: {
                        isValid = this.isValidFail(last.getPreviousSibling());
                        break;
                    }
                    default: {
                        isValid = false;
                    }
                }
            }
            if (!isValid) {
                this.log(ast, MSG_KEY, new Object[0]);
            }
        }
    }

    private boolean isTestMethod(DetailAST method) {
        boolean result = false;
        if (method != null) {
            result = this.importTest && AnnotationUtil.containsAnnotation((DetailAST)method, (String)"Test");
            for (int i = 0; !result && i < FQ_JUNIT_TESTS.size(); ++i) {
                result = AnnotationUtil.containsAnnotation((DetailAST)method, (String)FQ_JUNIT_TESTS.get(i));
            }
        }
        return result;
    }

    private boolean isValidFail(DetailAST expression) {
        boolean result = false;
        if (expression.getFirstChild().getType() == 27) {
            String methodCall;
            DetailAST ident = expression.getFirstChild().getFirstChild();
            if (ident.getType() == 58) {
                methodCall = ident.getText();
            } else {
                DetailAST identChild = ident.getFirstChild();
                if (identChild.getType() == 27) {
                    identChild = RequireFailForTryCatchInJunitCheck.getLastMethodInChain(identChild);
                    methodCall = FullIdent.createFullIdent((DetailAST)identChild.getFirstChild()).getText() + "." + FullIdent.createFullIdent((DetailAST)ident.getLastChild()).getText();
                } else {
                    methodCall = FullIdent.createFullIdent((DetailAST)ident).getText();
                }
            }
            result = this.acceptedFailMethodCalls.contains(methodCall);
        }
        return result;
    }

    private static DetailAST getLastMethodInChain(DetailAST methodCall) {
        DetailAST result = methodCall;
        DetailAST child = result.getFirstChild();
        while (child.getType() == 59 && child.getFirstChild().getType() == 27) {
            result = child.getFirstChild();
            child = result.getFirstChild();
        }
        return result;
    }

    private static DetailAST getMethod(DetailAST node) {
        DetailAST result = null;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type == 9) {
                result = token;
            }
            if (type == 9 || type == 181) break;
        }
        return result;
    }

    private static String getImportText(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow((DetailAST)ast) : FullIdent.createFullIdent((DetailAST)ast.getFirstChild().getNextSibling());
        return imp.getText();
    }

    private static String getMethodNameForStaticImport(String methodName) {
        int dotPos = methodName.indexOf(46);
        String result = dotPos < 0 ? methodName : methodName.substring(0, dotPos);
        return result;
    }

    static {
        for (String failMethod : FAIL_METHODS) {
            int hashPos = failMethod.lastIndexOf(35);
            String failMethodName = failMethod.substring(hashPos + 1, failMethod.length());
            String failClassName = failMethod.substring(0, hashPos);
            int lastDotPos = failClassName.lastIndexOf(46);
            String failClassSimpleName = failClassName.substring(lastDotPos + 1, failClassName.length());
            FAIL_METHOD_CALLS_BY_IMPORT.computeIfAbsent(failClassName, key -> new ArrayList()).add(failClassSimpleName + '.' + failMethodName);
            FAIL_METHOD_CALLS_BY_STATIC_IMPORT.computeIfAbsent(failClassName + ".*", key -> new ArrayList()).add(failMethodName);
            FAIL_METHOD_CALLS_BY_STATIC_IMPORT.computeIfAbsent(failClassName + '.' + RequireFailForTryCatchInJunitCheck.getMethodNameForStaticImport(failMethodName), key -> new ArrayList()).add(failMethodName);
        }
    }
}

