/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Pattern;

public class UniformEnumConstantNameCheck
extends AbstractCheck {
    public static final String MSG_NOT_VALID_MULTI = "enum.name.formats.violated";
    public static final String MSG_NOT_VALID_SINGLE = "enum.name.format.violated";
    public static final String CAMEL_PATTERN = "^[A-Z][a-zA-Z0-9]*$";
    public static final String UPPERCASE_PATTERN = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    public static final String[] DEFAULT_PATTERN = new String[]{"^[A-Z][a-zA-Z0-9]*$", "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$"};
    private List<Pattern> patterns;
    private int patternCount;

    public UniformEnumConstantNameCheck() {
        this.setFormats(DEFAULT_PATTERN);
    }

    public final void setFormats(String ... regexps) {
        this.patterns = new ArrayList<Pattern>(regexps.length);
        for (String regexp : regexps) {
            Pattern pattern = Pattern.compile(regexp, 0);
            this.patterns.add(pattern);
        }
        this.patternCount = regexps.length;
    }

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{154};
    }

    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST objBlock = ast.findFirstToken(6);
        BitSet conformedPatterns = new BitSet(this.patternCount);
        conformedPatterns.set(0, this.patternCount);
        for (DetailAST member = objBlock.getFirstChild(); member != null && !conformedPatterns.isEmpty(); member = member.getNextSibling()) {
            if (member.getType() != 155) continue;
            String enumName = member.findFirstToken(58).getText();
            BitSet matched = this.match(enumName, conformedPatterns);
            if (matched.isEmpty()) {
                this.logViolation(member, enumName, conformedPatterns);
            }
            conformedPatterns.and(matched);
        }
    }

    private void logViolation(DetailAST member, String enumName, BitSet violated) {
        String patternsString;
        String msgKey;
        if (violated.cardinality() == 1) {
            msgKey = MSG_NOT_VALID_SINGLE;
            patternsString = this.patterns.get(violated.nextSetBit(0)).toString();
        } else {
            msgKey = MSG_NOT_VALID_MULTI;
            ArrayList<Pattern> violatedPatterns = new ArrayList<Pattern>(violated.cardinality());
            int index = violated.nextSetBit(0);
            while (index >= 0) {
                violatedPatterns.add(this.patterns.get(index));
                index = violated.nextSetBit(index + 1);
            }
            patternsString = ((Object)violatedPatterns).toString();
        }
        this.log(member, msgKey, new Object[]{enumName, patternsString});
    }

    private BitSet match(String name, BitSet conformedPatterns) {
        BitSet result = new BitSet(this.patternCount);
        for (int i = 0; i < this.patterns.size(); ++i) {
            Pattern pattern;
            if (!conformedPatterns.get(i) || !(pattern = this.patterns.get(i)).matcher(name).find()) continue;
            result.set(i);
        }
        return result;
    }
}

